/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.MongoConnector;
import io.trino.plugin.mongodb.MongoPageSinkProvider;
import io.trino.plugin.mongodb.MongoPageSourceProvider;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSplitManager;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Singleton;

public class MongoClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(MongoConnector.class).in(Scopes.SINGLETON);
        binder.bind(MongoSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSinkProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MongoClientConfig.class);
    }

    @Singleton
    @Provides
    public static MongoSession createMongoSession(TypeManager typeManager, MongoClientConfig config) {
        Objects.requireNonNull(config, "config is null");
        MongoClientOptions.Builder options = MongoClientOptions.builder();
        options.connectionsPerHost(config.getConnectionsPerHost()).connectTimeout(config.getConnectionTimeout()).socketTimeout(config.getSocketTimeout()).socketKeepAlive(config.getSocketKeepAlive()).sslEnabled(config.getSslEnabled()).maxWaitTime(config.getMaxWaitTime()).maxConnectionIdleTime(config.getMaxConnectionIdleTime()).minConnectionsPerHost(config.getMinConnectionsPerHost()).readPreference(config.getReadPreference().getReadPreference()).writeConcern(config.getWriteConcern().getWriteConcern());
        if (config.getRequiredReplicaSetName() != null) {
            options.requiredReplicaSetName(config.getRequiredReplicaSetName());
        }
        MongoClient client = new MongoClient(config.getSeeds(), config.getCredentials(), options.build());
        return new MongoSession(typeManager, client, config);
    }
}

