/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.MongoSplit;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class MongoSplitManager
implements ConnectorSplitManager {
    private final List<HostAddress> addresses;

    @Inject
    public MongoSplitManager(MongoClientConfig config) {
        this.addresses = config.getSeeds().stream().map(s -> HostAddress.fromParts((String)s.getHost(), (int)s.getPort())).collect(Collectors.toList());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        MongoSplit split = new MongoSplit(this.addresses);
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)split));
    }
}

