/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import io.trino.plugin.mongodb.MongoMetadata;
import io.trino.plugin.mongodb.MongoPageSinkProvider;
import io.trino.plugin.mongodb.MongoPageSourceProvider;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSplitManager;
import io.trino.plugin.mongodb.MongoTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class MongoConnector
implements Connector {
    private final MongoSession mongoSession;
    private final MongoSplitManager splitManager;
    private final MongoPageSourceProvider pageSourceProvider;
    private final MongoPageSinkProvider pageSinkProvider;
    private final ConcurrentMap<ConnectorTransactionHandle, MongoMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MongoMetadata>();

    @Inject
    public MongoConnector(MongoSession mongoSession, MongoSplitManager splitManager, MongoPageSourceProvider pageSourceProvider, MongoPageSinkProvider pageSinkProvider) {
        this.mongoSession = mongoSession;
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        MongoTransactionHandle transaction = new MongoTransactionHandle();
        this.transactions.put(transaction, new MongoMetadata(this.mongoSession));
        return transaction;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        MongoMetadata metadata = (MongoMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MongoMetadata metadata = (MongoMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public void shutdown() {
        this.mongoSession.shutdown();
    }
}

