/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoPageSource;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class MongoPageSourceProvider
implements ConnectorPageSourceProvider {
    private final MongoSession mongoSession;

    @Inject
    public MongoPageSourceProvider(MongoSession mongoSession) {
        this.mongoSession = Objects.requireNonNull(mongoSession, "mongoSession is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        MongoTableHandle tableHandle = (MongoTableHandle)table;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle handle : Objects.requireNonNull(columns, "columns is null")) {
            handles.add((Object)((MongoColumnHandle)handle));
        }
        return new MongoPageSource(this.mongoSession, tableHandle, (List<MongoColumnHandle>)handles.build());
    }
}

