/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.CharMatcher;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;

public final class ObjectIdFunctions {
    private ObjectIdFunctions() {
    }

    @Description(value="Mongodb ObjectId")
    @ScalarFunction
    @SqlType(value="ObjectId")
    public static Slice objectid() {
        return Slices.wrappedBuffer((byte[])new ObjectId().toByteArray());
    }

    @Description(value="Mongodb ObjectId from the given string")
    @ScalarFunction
    @SqlType(value="ObjectId")
    public static Slice objectid(@SqlType(value="varchar") Slice value) {
        return Slices.wrappedBuffer((byte[])new ObjectId(CharMatcher.is((char)' ').removeFrom((CharSequence)value.toStringUtf8())).toByteArray());
    }

    @Description(value="Timestamp from the given Mongodb ObjectId")
    @ScalarFunction
    @SqlType(value="timestamp(3) with time zone")
    public static long objectidTimestamp(@SqlType(value="ObjectId") Slice value) {
        int epochSeconds = new ObjectId(value.getBytes()).getTimestamp();
        return DateTimeEncoding.packDateTimeWithZone((long)TimeUnit.SECONDS.toMillis(epochSeconds), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    @Description(value="Mongodb ObjectId from the given timestamp")
    @ScalarFunction
    @SqlType(value="ObjectId")
    public static Slice timestampObjectid(@SqlType(value="timestamp(0) with time zone") long timestamp) {
        ObjectId objectId = ObjectId.getSmallestWithDate((Date)new Date(DateTimeEncoding.unpackMillisUtc((long)timestamp)));
        return Slices.wrappedBuffer((byte[])objectId.toByteArray());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@LiteralParameter(value="x") long x, @SqlType(value="ObjectId") Slice value) {
        String hexString = new ObjectId(value.getBytes()).toString();
        if ((long)hexString.length() > x) {
            hexString = hexString.substring(0, Math.toIntExact(x));
        }
        return Slices.utf8Slice((String)hexString);
    }
}

