/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import io.trino.plugin.mongodb.ReadPreferenceType;
import io.trino.plugin.mongodb.WriteConcernType;
import java.io.File;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@DefunctConfig(value={"mongodb.connection-per-host", "mongodb.socket-keep-alive", "mongodb.seeds", "mongodb.credentials"})
public class MongoClientConfig {
    private String schemaCollection = "_schema";
    private boolean caseInsensitiveNameMatching;
    private String connectionUrl;
    private int minConnectionsPerHost;
    private int connectionsPerHost = 100;
    private int maxWaitTime = 120000;
    private int connectionTimeout = 10000;
    private int socketTimeout;
    private int maxConnectionIdleTime;
    private boolean tlsEnabled;
    private File keystorePath;
    private String keystorePassword;
    private File truststorePath;
    private String truststorePassword;
    private int cursorBatchSize;
    private ReadPreferenceType readPreference = ReadPreferenceType.PRIMARY;
    private WriteConcernType writeConcern = WriteConcernType.ACKNOWLEDGED;
    private String requiredReplicaSetName;
    private String implicitRowFieldPrefix = "_pos";

    @AssertTrue(message="'mongodb.tls.keystore-path', 'mongodb.tls.keystore-password', 'mongodb.tls.truststore-path' and 'mongodb.tls.truststore-password' must be empty when TLS is disabled")
    public @AssertTrue(message="'mongodb.tls.keystore-path', 'mongodb.tls.keystore-password', 'mongodb.tls.truststore-path' and 'mongodb.tls.truststore-password' must be empty when TLS is disabled") boolean isValidTlsConfig() {
        if (!this.tlsEnabled) {
            return this.keystorePath == null && this.keystorePassword == null && this.truststorePath == null && this.truststorePassword == null;
        }
        return true;
    }

    @NotNull
    public String getSchemaCollection() {
        return this.schemaCollection;
    }

    @Config(value="mongodb.schema-collection")
    public MongoClientConfig setSchemaCollection(String schemaCollection) {
        this.schemaCollection = schemaCollection;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="mongodb.case-insensitive-name-matching")
    public MongoClientConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @Pattern(message="Invalid connection URL. Expected mongodb:// or mongodb+srv://", regexp="^mongodb(\\+srv)?://.*")
    public @NotNull @Pattern(message="Invalid connection URL. Expected mongodb:// or mongodb+srv://", regexp="^mongodb(\\+srv)?://.*") String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="mongodb.connection-url")
    @ConfigSecuritySensitive
    public MongoClientConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Config(value="mongodb.min-connections-per-host")
    public MongoClientConfig setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    @Config(value="mongodb.connections-per-host")
    public MongoClientConfig setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Config(value="mongodb.max-wait-time")
    public MongoClientConfig setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="mongodb.connection-timeout")
    public MongoClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Config(value="mongodb.socket-timeout")
    public MongoClientConfig setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @NotNull
    public ReadPreferenceType getReadPreference() {
        return this.readPreference;
    }

    @Config(value="mongodb.read-preference")
    public MongoClientConfig setReadPreference(ReadPreferenceType readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    @NotNull
    public WriteConcernType getWriteConcern() {
        return this.writeConcern;
    }

    @Config(value="mongodb.write-concern")
    public MongoClientConfig setWriteConcern(WriteConcernType writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Config(value="mongodb.required-replica-set")
    public MongoClientConfig setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
        return this;
    }

    public int getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    @Config(value="mongodb.cursor-batch-size")
    public MongoClientConfig setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
        return this;
    }

    @NotNull
    public String getImplicitRowFieldPrefix() {
        return this.implicitRowFieldPrefix;
    }

    @Config(value="mongodb.implicit-row-field-prefix")
    public MongoClientConfig setImplicitRowFieldPrefix(String implicitRowFieldPrefix) {
        this.implicitRowFieldPrefix = implicitRowFieldPrefix;
        return this;
    }

    public boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="mongodb.tls.enabled")
    @LegacyConfig(value={"mongodb.ssl.enabled"})
    public MongoClientConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="mongodb.tls.keystore-path")
    public MongoClientConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="mongodb.tls.keystore-password")
    @ConfigSecuritySensitive
    public MongoClientConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<@FileExists File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="mongodb.tls.truststore-path")
    public MongoClientConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="mongodb.tls.truststore-password")
    @ConfigSecuritySensitive
    public MongoClientConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Config(value="mongodb.max-connection-idle-time")
    public MongoClientConfig setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        return this;
    }
}

