/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.SslSettings;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ssl.SslUtils;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.MongoConnector;
import io.trino.plugin.mongodb.MongoPageSinkProvider;
import io.trino.plugin.mongodb.MongoPageSourceProvider;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSplitManager;
import io.trino.plugin.mongodb.ptf.Query;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.type.TypeManager;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;

public class MongoClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(MongoConnector.class).in(Scopes.SINGLETON);
        binder.bind(MongoSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSinkProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MongoClientConfig.class);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public static MongoSession createMongoSession(TypeManager typeManager, MongoClientConfig config) {
        MongoClientSettings.Builder options = MongoClientSettings.builder();
        options.writeConcern(config.getWriteConcern().getWriteConcern()).readPreference(config.getReadPreference().getReadPreference()).applyToConnectionPoolSettings(builder -> builder.maxConnectionIdleTime((long)config.getMaxConnectionIdleTime(), TimeUnit.MILLISECONDS).maxWaitTime((long)config.getMaxWaitTime(), TimeUnit.MILLISECONDS).minSize(config.getMinConnectionsPerHost()).maxSize(config.getConnectionsPerHost())).applyToSocketSettings(builder -> builder.connectTimeout(config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout(config.getSocketTimeout(), TimeUnit.MILLISECONDS));
        if (config.getRequiredReplicaSetName() != null) {
            options.applyToClusterSettings(builder -> builder.requiredReplicaSetName(config.getRequiredReplicaSetName()));
        }
        if (config.getTlsEnabled()) {
            options.applyToSslSettings(builder -> {
                builder.enabled(true);
                MongoClientModule.buildSslContext(config.getKeystorePath(), config.getKeystorePassword(), config.getTruststorePath(), config.getTruststorePassword()).ifPresent(arg_0 -> ((SslSettings.Builder)builder).context(arg_0));
            });
        }
        options.applyConnectionString(new ConnectionString(config.getConnectionUrl()));
        MongoClient client = MongoClients.create((MongoClientSettings)options.build());
        return new MongoSession(typeManager, client, config);
    }

    private static Optional<SSLContext> buildSslContext(Optional<File> keystorePath, Optional<String> keystorePassword, Optional<File> truststorePath, Optional<String> truststorePassword) {
        if (keystorePath.isEmpty() && truststorePath.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SslUtils.createSSLContext(keystorePath, keystorePassword, truststorePath, truststorePassword));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }
}

