/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.bson.Document;

public class MongoTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final RemoteTableName remoteTableName;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<Document> filter;
    private final OptionalInt limit;

    public MongoTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, Optional<Document> filter) {
        this(schemaTableName, remoteTableName, filter, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty());
    }

    @JsonCreator
    public MongoTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="remoteTableName") RemoteTableName remoteTableName, @JsonProperty(value="filter") Optional<Document> filter, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="limit") OptionalInt limit) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public RemoteTableName getRemoteTableName() {
        return this.remoteTableName;
    }

    @JsonProperty
    public Optional<Document> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public OptionalInt getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.filter, this.constraint, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoTableHandle other = (MongoTableHandle)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.remoteTableName, other.remoteTableName) && Objects.equals(this.filter, other.filter) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaTableName", (Object)this.schemaTableName).add("remoteTableName", (Object)this.remoteTableName).add("filter", this.filter).add("limit", (Object)this.limit).add("constraint", this.constraint).toString();
    }
}

