/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import java.io.File;
import java.util.Optional;

public class MongoSslConfig {
    private File keystorePath;
    private String keystorePassword;
    private File truststorePath;
    private String truststorePassword;

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="mongodb.tls.keystore-path")
    public MongoSslConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="mongodb.tls.keystore-password")
    @ConfigSecuritySensitive
    public MongoSslConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<@FileExists File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="mongodb.tls.truststore-path")
    public MongoSslConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="mongodb.tls.truststore-password")
    @ConfigSecuritySensitive
    public MongoSslConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }
}

