/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;

public class MongoColumnHandle
implements ColumnHandle {
    private final String baseName;
    private final List<String> dereferenceNames;
    private final Type type;
    private final boolean hidden;
    private final boolean dbRefField;
    private final Optional<String> comment;

    @JsonCreator
    public MongoColumnHandle(@JsonProperty(value="baseName") String baseName, @JsonProperty(value="dereferenceNames") List<String> dereferenceNames, @JsonProperty(value="columnType") Type type, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="dbRefField") boolean dbRefField, @JsonProperty(value="comment") Optional<String> comment) {
        this.baseName = Objects.requireNonNull(baseName, "baseName is null");
        this.dereferenceNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceNames, "dereferenceNames is null"));
        this.type = Objects.requireNonNull(type, "type is null");
        this.hidden = hidden;
        this.dbRefField = dbRefField;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public String getBaseName() {
        return this.baseName;
    }

    @JsonProperty
    public List<String> getDereferenceNames() {
        return this.dereferenceNames;
    }

    @JsonProperty(value="columnType")
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isDbRefField() {
        return this.dbRefField;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    public ColumnMetadata toColumnMetadata() {
        return ColumnMetadata.builder().setName(this.getQualifiedName()).setType(this.type).setHidden(this.hidden).setComment(this.comment).build();
    }

    @JsonIgnore
    public String getQualifiedName() {
        return Joiner.on((char)'.').join((Iterable)ImmutableList.builder().add((Object)this.baseName).addAll(this.dereferenceNames).build());
    }

    @JsonIgnore
    public boolean isBaseColumn() {
        return this.dereferenceNames.isEmpty();
    }

    public Document getDocument() {
        return new Document().append("name", (Object)this.getQualifiedName()).append("type", (Object)this.type.getTypeSignature().toString()).append("hidden", (Object)this.hidden).append("dbRefField", (Object)this.dbRefField).append("comment", this.comment.orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.baseName, this.dereferenceNames, this.type, this.hidden, this.dbRefField, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoColumnHandle other = (MongoColumnHandle)obj;
        return Objects.equals(this.baseName, other.baseName) && Objects.equals(this.dereferenceNames, other.dereferenceNames) && Objects.equals(this.type, other.type) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.dbRefField, other.dbRefField) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.getQualifiedName() + ":" + String.valueOf(this.type);
    }
}

