/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.mongodb.MongoPageSinkProvider;
import io.trino.plugin.mongodb.MongoPageSourceProvider;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSplitManager;
import io.trino.plugin.mongodb.MongoTransactionManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MongoConnector
implements Connector {
    private final MongoSession mongoSession;
    private final MongoTransactionManager transactionManager;
    private final MongoSplitManager splitManager;
    private final MongoPageSourceProvider pageSourceProvider;
    private final MongoPageSinkProvider pageSinkProvider;
    private final Set<ConnectorTableFunction> connectorTableFunctions;
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public MongoConnector(MongoSession mongoSession, MongoTransactionManager transactionManager, MongoSplitManager splitManager, MongoPageSourceProvider pageSourceProvider, MongoPageSinkProvider pageSinkProvider, Set<ConnectorTableFunction> connectorTableFunctions, Set<SessionPropertiesProvider> sessionPropertiesProviders) {
        this.mongoSession = mongoSession;
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.connectorTableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(connectorTableFunctions, "connectorTableFunctions is null"));
        this.sessionProperties = (List)sessionPropertiesProviders.stream().flatMap(sessionPropertiesProvider -> sessionPropertiesProvider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return this.transactionManager.beginTransaction(isolationLevel);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        return this.transactionManager.getMetadata(transaction);
    }

    public void commit(ConnectorTransactionHandle transaction) {
        this.transactionManager.commit(transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        this.transactionManager.rollback(transaction);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.connectorTableFunctions;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public void shutdown() {
        this.mongoSession.shutdown();
    }
}

