/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.inject.Inject;
import io.trino.plugin.mongodb.MongoServerDetailsProvider;
import io.trino.plugin.mongodb.MongoSplit;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.Objects;

public class MongoSplitManager
implements ConnectorSplitManager {
    private final MongoServerDetailsProvider serverDetailsProvider;

    @Inject
    public MongoSplitManager(MongoServerDetailsProvider serverDetailsProvider) {
        this.serverDetailsProvider = Objects.requireNonNull(serverDetailsProvider, "serverDetailsProvider is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        MongoSplit split = new MongoSplit(this.serverDetailsProvider.getServerAddress());
        return new FixedSplitSource((ConnectorSplit)split);
    }
}

