/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.mongo.v3_1;

import com.mongodb.ServerAddress;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandStartedEvent;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.mongo.v3_1.StringBuilderWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

class MongoDbAttributesGetter
implements DbClientAttributesGetter<CommandStartedEvent> {
    @Nullable
    private static final Method IS_TRUNCATED_METHOD = Arrays.stream(JsonWriter.class.getMethods()).filter(method -> method.getName().equals("isTruncated")).findFirst().orElse(null);
    private static final String HIDDEN_CHAR = "?";
    private final boolean statementSanitizationEnabled;
    private final int maxNormalizedQueryLength;
    @Nullable
    private final JsonWriterSettings jsonWriterSettings;

    MongoDbAttributesGetter(boolean statementSanitizationEnabled, int maxNormalizedQueryLength) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        this.maxNormalizedQueryLength = maxNormalizedQueryLength;
        this.jsonWriterSettings = MongoDbAttributesGetter.createJsonWriterSettings(maxNormalizedQueryLength);
    }

    public String getSystem(CommandStartedEvent event) {
        return "mongodb";
    }

    @Nullable
    public String getUser(CommandStartedEvent event) {
        return null;
    }

    @Nullable
    public String getName(CommandStartedEvent event) {
        return event.getDatabaseName();
    }

    @Nullable
    public String getConnectionString(CommandStartedEvent event) {
        ServerAddress sa;
        ConnectionDescription connectionDescription = event.getConnectionDescription();
        if (connectionDescription != null && (sa = connectionDescription.getServerAddress()) != null) {
            String host = sa.getHost();
            int port = sa.getPort();
            if (host != null && port != 0) {
                return "mongodb://" + host + ":" + port;
            }
        }
        return null;
    }

    public String getStatement(CommandStartedEvent event) {
        return this.sanitizeStatement(event.getCommand());
    }

    @Nullable
    public String getOperation(CommandStartedEvent event) {
        return event.getCommandName();
    }

    String sanitizeStatement(BsonDocument command) {
        JsonWriter jsonWriter;
        StringBuilderWriter stringWriter = new StringBuilderWriter(128);
        JsonWriter jsonWriter2 = jsonWriter = this.jsonWriterSettings != null ? new JsonWriter((Writer)stringWriter, this.jsonWriterSettings) : new JsonWriter((Writer)stringWriter);
        if (this.statementSanitizationEnabled) {
            MongoDbAttributesGetter.writeScrubbed(command, jsonWriter, true);
        } else {
            new BsonDocumentCodec().encode((BsonWriter)jsonWriter, command, EncoderContext.builder().build());
        }
        StringBuilder buf = stringWriter.getBuilder();
        if (buf.length() <= this.maxNormalizedQueryLength) {
            return buf.toString();
        }
        return buf.substring(0, this.maxNormalizedQueryLength);
    }

    @Nullable
    private static JsonWriterSettings createJsonWriterSettings(int maxNormalizedQueryLength) {
        JsonWriterSettings settings = null;
        try {
            Optional<Method> buildMethod = Arrays.stream(JsonWriterSettings.class.getMethods()).filter(method -> method.getName().equals("builder")).findFirst();
            if (buildMethod.isPresent()) {
                Optional<Method> maxLengthMethod;
                Class<?> builderClass = buildMethod.get().getReturnType();
                Object builder = buildMethod.get().invoke(null, (Object[])null);
                Optional<Method> indentMethod = Arrays.stream(builderClass.getMethods()).filter(method -> method.getName().equals("indent")).findFirst();
                if (indentMethod.isPresent()) {
                    indentMethod.get().invoke(builder, false);
                }
                if ((maxLengthMethod = Arrays.stream(builderClass.getMethods()).filter(method -> method.getName().equals("maxLength")).findFirst()).isPresent()) {
                    maxLengthMethod.get().invoke(builder, maxNormalizedQueryLength);
                }
                settings = (JsonWriterSettings)builderClass.getMethod("build", null).invoke(builder, (Object[])null);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (settings == null) {
            try {
                settings = (JsonWriterSettings)JsonWriterSettings.class.getConstructor(Boolean.TYPE).newInstance(false);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return settings;
    }

    private static boolean writeScrubbed(BsonDocument origin, JsonWriter writer, boolean isRoot) {
        writer.writeStartDocument();
        boolean firstField = true;
        for (Map.Entry entry : origin.entrySet()) {
            writer.writeName((String)entry.getKey());
            if (isRoot && firstField && ((BsonValue)entry.getValue()).isString()) {
                writer.writeString(((BsonValue)entry.getValue()).asString().getValue());
            } else if (MongoDbAttributesGetter.writeScrubbed((BsonValue)entry.getValue(), writer)) {
                return true;
            }
            firstField = false;
        }
        writer.writeEndDocument();
        return false;
    }

    private static boolean writeScrubbed(BsonArray origin, JsonWriter writer) {
        writer.writeStartArray();
        for (BsonValue value : origin) {
            if (!MongoDbAttributesGetter.writeScrubbed(value, writer)) continue;
            return true;
        }
        writer.writeEndArray();
        return false;
    }

    private static boolean writeScrubbed(BsonValue origin, JsonWriter writer) {
        if (origin.isDocument()) {
            return MongoDbAttributesGetter.writeScrubbed(origin.asDocument(), writer, false);
        }
        if (origin.isArray()) {
            return MongoDbAttributesGetter.writeScrubbed(origin.asArray(), writer);
        }
        writer.writeString(HIDDEN_CHAR);
        return MongoDbAttributesGetter.isTruncated(writer);
    }

    private static boolean isTruncated(JsonWriter writer) {
        if (IS_TRUNCATED_METHOD == null) {
            return false;
        }
        try {
            return (Boolean)IS_TRUNCATED_METHOD.invoke((Object)writer, (Object[])null);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }
}

