/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableMap;
import com.mongodb.ConnectionString;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class AuthenticatedMongoServer
implements Closeable {
    private static final int MONGODB_INTERNAL_PORT = 27017;
    private static final String ROOT_USER = "root";
    private static final String ROOT_PASSWORD = "password";
    private final GenericContainer<?> dockerContainer;

    public AuthenticatedMongoServer(String mongoVersion) {
        this.dockerContainer = new GenericContainer("mongo:" + Objects.requireNonNull(mongoVersion, "mongoVersion is null")).withStartupAttempts(3).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Listening on 0\\.0\\.0\\.0.*", (int)1)).withEnv("MONGO_INITDB_ROOT_USERNAME", ROOT_USER).withEnv("MONGO_INITDB_ROOT_PASSWORD", ROOT_PASSWORD).withEnv("MONGO_INITDB_DATABASE", "admin").withExposedPorts(new Integer[]{27017}).withCommand("--auth --bind_ip 0.0.0.0");
        this.dockerContainer.start();
    }

    public ConnectionString rootUserConnectionString() {
        return new ConnectionString("mongodb://%s:%s@%s:%d".formatted(ROOT_USER, ROOT_PASSWORD, this.dockerContainer.getHost(), this.dockerContainer.getMappedPort(27017)));
    }

    public ConnectionString testUserConnectionString(String database, String user, String password) {
        return new ConnectionString("mongodb://%s:%s@%s:%d/%s".formatted(user, password, this.dockerContainer.getHost(), this.dockerContainer.getMappedPort(27017), database));
    }

    public static Document createRole(String role, List<Document> privileges, List<Object> roles) {
        return new Document((Map)ImmutableMap.of((Object)"createRole", (Object)role, (Object)"privileges", privileges, (Object)"roles", roles));
    }

    public static Document privilege(Document resource, List<String> actions) {
        return new Document((Map)ImmutableMap.of((Object)"resource", (Object)resource, (Object)"actions", actions));
    }

    public static Document resource(String database, String collectionName) {
        return new Document((Map)ImmutableMap.of((Object)"db", (Object)database, (Object)"collection", (Object)collectionName));
    }

    public static Document createUser(String user, String password, List<Document> roles) {
        return new Document((Map)ImmutableMap.of((Object)"createUser", (Object)user, (Object)"pwd", (Object)password, (Object)"roles", roles));
    }

    public static Document role(String database, String role) {
        return new Document((Map)ImmutableMap.of((Object)"role", (Object)role, (Object)"db", (Object)database));
    }

    @Override
    public void close() {
        this.dockerContainer.close();
    }
}

