/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorSmokeTest;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.TestTable;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseMongoConnectorSmokeTest
extends BaseConnectorSmokeTest {
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, TestingConnectorBehavior.SUPPORTS_MERGE, TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA, TestingConnectorBehavior.SUPPORTS_TRUNCATE, TestingConnectorBehavior.SUPPORTS_UPDATE -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testProjectionPushdown() {
        try (TestTable testTable = this.newTrinoTable("test_projection_pushdown_multiple_rows_", "(id INT, nested1 ROW(child1 INT, child2 VARCHAR))", (List)ImmutableList.of((Object)"(1, ROW(10, 'a'))", (Object)"(2, ROW(NULL, 'b'))", (Object)"(3, ROW(30, 'c'))", (Object)"(4, NULL)"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, nested1.child1 FROM " + testTable.getName() + " WHERE nested1.child2 = 'c'"))).matches("VALUES (3, 30)").isFullyPushedDown();
        }
    }

    @Test
    public void testReadDottedField() {
        try (TestTable testTable = this.newTrinoTable("test_read_dotted_field_", "(root ROW(\"dotted.field\" VARCHAR, field VARCHAR))", (List)ImmutableList.of((Object)"ROW(ROW('foo', 'bar'))"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT root.\"dotted.field\" FROM " + testTable.getName()))).matches("SELECT varchar 'foo'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT root.\"dotted.field\", root.field FROM " + testTable.getName()))).matches("SELECT varchar 'foo', varchar 'bar'");
        }
    }

    @Test
    public void testReadDollarPrefixedField() {
        try (TestTable testTable = this.newTrinoTable("test_read_dotted_field_", "(root ROW(\"$field1\" VARCHAR, field2 VARCHAR))", (List)ImmutableList.of((Object)"ROW(ROW('foo', 'bar'))"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT root.\"$field1\" FROM " + testTable.getName()))).matches("SELECT varchar 'foo'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT root.\"$field1\", root.field2 FROM " + testTable.getName()))).matches("SELECT varchar 'foo', varchar 'bar'");
        }
    }

    @Test
    public void testProjectionPushdownWithHighlyNestedData() {
        try (TestTable testTable = this.newTrinoTable("test_projection_pushdown_highly_nested_data_", "(id INT, row1_t ROW(f1 INT, f2 INT, row2_t ROW (f1 INT, f2 INT, row3_t ROW(f1 INT, f2 INT))))", (List)ImmutableList.of((Object)"(1, ROW(2, 3, ROW(4, 5, ROW(6, 7))))", (Object)"(11, ROW(12, 13, ROW(14, 15, ROW(16, 17))))", (Object)"(21, ROW(22, 23, ROW(24, 25, ROW(26, 27))))"));){
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f2 FROM " + testTable.getName(), "VALUES (1, 7), (11, 17), (21, 27)");
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f2, CAST(row1_t AS JSON) FROM " + testTable.getName(), "VALUES (1, 7, '{\"f1\":2,\"f2\":3,\"row2_t\":{\"f1\":4,\"f2\":5,\"row3_t\":{\"f1\":6,\"f2\":7}}}'), (11, 17, '{\"f1\":12,\"f2\":13,\"row2_t\":{\"f1\":14,\"f2\":15,\"row3_t\":{\"f1\":16,\"f2\":17}}}'), (21, 27, '{\"f1\":22,\"f2\":23,\"row2_t\":{\"f1\":24,\"f2\":25,\"row3_t\":{\"f1\":26,\"f2\":27}}}')");
            this.assertQuery("SELECT id, CAST(row1_t.row2_t.row3_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 = 27", "VALUES (21, '{\"f1\":26,\"f2\":27}')");
            this.assertQuery("SELECT id, CAST(row1_t.row2_t.row3_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 > 20", "VALUES (21, '{\"f1\":26,\"f2\":27}')");
            this.assertQuery("SELECT id, CAST(row1_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 = 27", "VALUES (21, '{\"f1\":22,\"f2\":23,\"row2_t\":{\"f1\":24,\"f2\":25,\"row3_t\":{\"f1\":26,\"f2\":27}}}')");
            this.assertQuery("SELECT id, CAST(row1_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 > 20", "VALUES (21, '{\"f1\":22,\"f2\":23,\"row2_t\":{\"f1\":24,\"f2\":25,\"row3_t\":{\"f1\":26,\"f2\":27}}}')");
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f1 FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t = ROW(16, 17)", "VALUES (11, 16)");
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f1 FROM " + testTable.getName() + " WHERE row1_t = ROW(22, 23, ROW(24, 25, ROW(26, 27)))", "VALUES (21, 26)");
        }
    }
}

