/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.mongodb.MongoQueryRunner;
import io.trino.plugin.mongodb.MongoServer;
import io.trino.spi.Plugin;
import io.trino.testing.BaseFailureRecoveryTest;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class BaseMongoFailureRecoveryTest
extends BaseFailureRecoveryTest {
    public BaseMongoFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties, Module failureInjectionModule) throws Exception {
        return ((MongoQueryRunner.Builder)((MongoQueryRunner.Builder)((MongoQueryRunner.Builder)((MongoQueryRunner.Builder)MongoQueryRunner.builder((MongoServer)this.closeAfterClass(new MongoServer())).setExtraProperties(configProperties)).setCoordinatorProperties(coordinatorProperties)).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", (Map)ImmutableMap.of((Object)"exchange.base-directories", (Object)(System.getProperty("java.io.tmpdir") + "/trino-local-file-system-exchange-manager")));
        })).setAdditionalModule(failureInjectionModule)).setInitialTables(requiredTpchTables).build();
    }

    @Test
    protected void testAnalyzeTable() {
        Assertions.assertThatThrownBy(() -> super.testAnalyzeTable()).hasMessageMatching("This connector does not support analyze");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testDelete() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testDeleteWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testRefreshMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testRefreshMaterializedView()).hasMessageContaining("This connector does not support creating materialized views");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testUpdateWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testUpdateWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    protected boolean areWriteRetriesSupported() {
        return true;
    }
}

