/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.mongodb.client.MongoClient;
import io.airlift.testing.Closeables;
import io.trino.plugin.mongodb.MongoTestTable;
import io.trino.testing.datatype.ColumnSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TemporaryRelation;
import io.trino.testing.sql.TrinoSqlExecutor;
import java.util.List;
import java.util.Objects;
import org.bson.Document;

public final class MongoCreateAndInsertDataSetup
implements DataSetup {
    private final TrinoSqlExecutor trinoSqlExecutor;
    private final MongoClient mongoClient;
    private final String databaseName;
    private final String tableNamePrefix;

    public MongoCreateAndInsertDataSetup(TrinoSqlExecutor trinoSqlExecutor, MongoClient mongoClient, String databaseName, String tableNamePrefix) {
        this.trinoSqlExecutor = Objects.requireNonNull(trinoSqlExecutor, "trinoSqlExecutor is null");
        this.mongoClient = Objects.requireNonNull(mongoClient, "mongoClient is null");
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableNamePrefix = Objects.requireNonNull(tableNamePrefix, "tableNamePrefix is null");
    }

    public TemporaryRelation setupTemporaryRelation(List<ColumnSetup> inputs) {
        MongoTestTable testTable = new MongoTestTable((SqlExecutor)this.trinoSqlExecutor, this.tableNamePrefix);
        try {
            this.insertRows(testTable, inputs);
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{testTable});
            throw e;
        }
        return testTable;
    }

    private void insertRows(MongoTestTable testTable, List<ColumnSetup> inputs) {
        int i = 0;
        StringBuilder json = new StringBuilder("{");
        for (ColumnSetup columnSetup : inputs) {
            json.append(String.format("col_%d: ", i++));
            json.append(columnSetup.getInputLiteral());
            if (i == inputs.size()) continue;
            json.append(",");
        }
        json.append("}");
        this.mongoClient.getDatabase(this.databaseName).getCollection(testTable.getName()).insertOne((Object)Document.parse((String)json.toString()));
    }
}

