/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.plugin.mongodb.MongoPlugin;
import io.trino.plugin.mongodb.MongoServer;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MongoQueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private MongoQueryRunner() {
    }

    public static Builder builder(MongoServer server) {
        return new Builder().addConnectorProperties(Map.of("mongodb.connection-url", server.getConnectionString().toString()));
    }

    public static MongoClient createMongoClient(MongoServer server) {
        return MongoClients.create((ConnectionString)server.getConnectionString());
    }

    public static void main(String[] args) throws Exception {
        DistributedQueryRunner queryRunner = ((Builder)MongoQueryRunner.builder(new MongoServer()).addCoordinatorProperty("http-server.http.port", "8080")).setInitialTables(TpchTable.getTables()).build();
        Logger log = Logger.get(MongoQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    static {
        Logging logging = Logging.initialize();
        logging.setLevel("org.mongodb.driver", Level.OFF);
    }

    public static final class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private final Map<String, String> connectorProperties = new HashMap<String, String>();
        private List<TpchTable<?>> initialTables = ImmutableList.of();

        private Builder() {
            super(TestingSession.testSessionBuilder().setCatalog("mongodb").setSchema(MongoQueryRunner.TPCH_SCHEMA).build());
        }

        @CanIgnoreReturnValue
        public Builder addConnectorProperties(Map<String, String> connectorProperties) {
            this.connectorProperties.putAll(Objects.requireNonNull(connectorProperties, "connectorProperties is null"));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog(MongoQueryRunner.TPCH_SCHEMA, MongoQueryRunner.TPCH_SCHEMA);
                queryRunner.installPlugin((Plugin)new MongoPlugin());
                queryRunner.createCatalog("mongodb", "mongodb", this.connectorProperties);
                queryRunner.execute("CREATE SCHEMA mongodb.tpch");
                QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)MongoQueryRunner.TPCH_SCHEMA, (String)"tiny", this.initialTables);
                return queryRunner;
            }
            catch (Throwable e) {
                Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
                throw e;
            }
        }
    }
}

