/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.mongodb.ConnectionString;
import java.io.Closeable;
import org.testcontainers.containers.MongoDBContainer;

public class MongoServer
implements Closeable {
    private final MongoDBContainer dockerContainer;

    public MongoServer() {
        this("4.2.0");
    }

    public MongoServer(String mongoVersion) {
        this.dockerContainer = (MongoDBContainer)((MongoDBContainer)((MongoDBContainer)new MongoDBContainer("mongo:" + mongoVersion).withStartupAttempts(3)).withEnv("MONGO_INITDB_DATABASE", "tpch")).withCommand("--bind_ip 0.0.0.0");
        this.dockerContainer.start();
    }

    public ConnectionString getConnectionString() {
        return new ConnectionString(this.dockerContainer.getReplicaSetUrl());
    }

    @Override
    public void close() {
        this.dockerContainer.close();
    }
}

