/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import io.trino.plugin.mongodb.MongoQueryRunner;
import io.trino.plugin.mongodb.MongoServer;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMongoCaseInsensitiveMapping
extends AbstractTestQueryFramework {
    private final MongoServer server = new MongoServer();
    private final MongoClient client = MongoQueryRunner.createMongoClient(this.server);

    protected QueryRunner createQueryRunner() throws Exception {
        return MongoQueryRunner.builder(this.server).addConnectorProperties(Map.of("mongodb.case-insensitive-name-matching", "true")).build();
    }

    @AfterAll
    public final void destroy() {
        this.server.close();
        this.client.close();
    }

    @Test
    public void testCaseInsensitive() {
        MongoCollection collection = this.client.getDatabase("testCase").getCollection("testInsensitive");
        collection.insertOne((Object)new Document((Map)ImmutableMap.of((Object)"Name", (Object)"abc", (Object)"Value", (Object)1)));
        this.assertQuery("SHOW SCHEMAS IN mongodb LIKE 'testcase'", "SELECT 'testcase'");
        this.assertQuery("SHOW TABLES IN testcase", "SELECT 'testinsensitive'");
        this.assertQuery("SHOW COLUMNS FROM testcase.testInsensitive", "VALUES ('name', 'varchar', '', ''), ('value', 'bigint', '', '')");
        this.assertQuery("SELECT name, value FROM testcase.testinsensitive", "SELECT 'abc', 1");
        this.assertUpdate("INSERT INTO testcase.testinsensitive VALUES('def', 2)", 1L);
        this.assertQuery("SELECT value FROM testcase.testinsensitive WHERE name = 'def'", "SELECT 2");
        this.assertUpdate("DROP TABLE testcase.testinsensitive");
        this.assertQueryReturnsEmptyResult("SHOW TABLES IN testcase");
        this.assertUpdate("DROP SCHEMA testcase");
        this.assertQueryReturnsEmptyResult("SHOW SCHEMAS IN mongodb LIKE 'testcase'");
    }

    @Test
    public void testCaseInsensitiveRenameTable() {
        MongoCollection collection = this.client.getDatabase("testCase_RenameTable").getCollection("testInsensitive_RenameTable");
        collection.insertOne((Object)new Document((Map)ImmutableMap.of((Object)"value", (Object)1)));
        this.assertQuery("SHOW TABLES IN testcase_renametable", "SELECT 'testinsensitive_renametable'");
        this.assertQuery("SELECT value FROM testcase_renametable.testinsensitive_renametable", "SELECT 1");
        this.assertUpdate("ALTER TABLE testcase_renametable.testinsensitive_renametable RENAME TO testcase_renametable.testinsensitive_renamed_table");
        this.assertQuery("SHOW TABLES IN testcase_renametable", "SELECT 'testinsensitive_renamed_table'");
        this.assertQuery("SELECT value FROM testcase_renametable.testinsensitive_renamed_table", "SELECT 1");
        this.assertUpdate("DROP TABLE testcase_renametable.testinsensitive_renamed_table");
    }

    @Test
    public void testNonLowercaseViewName() {
        MongoCollection collection = this.client.getDatabase("NonLowercaseSchema").getCollection("test_collection");
        collection.insertOne((Object)new Document((Map)ImmutableMap.of((Object)"Name", (Object)"abc", (Object)"Value", (Object)1)));
        this.client.getDatabase("NonLowercaseSchema").createView("lowercase_view", "test_collection", (List)ImmutableList.of());
        this.assertQuery("SELECT value FROM nonlowercaseschema.lowercase_view WHERE name = 'abc'", "SELECT 1");
        collection = this.client.getDatabase("test_database").getCollection("test_collection");
        collection.insertOne((Object)new Document((Map)ImmutableMap.of((Object)"Name", (Object)"abc", (Object)"Value", (Object)1)));
        this.client.getDatabase("test_database").createView("NonLowercaseView", "test_collection", (List)ImmutableList.of());
        this.assertQuery("SELECT value FROM test_database.nonlowercaseview WHERE name = 'abc'", "SELECT 1");
        this.client.getDatabase("NonLowercaseSchema").createView("NonLowercaseView", "test_collection", (List)ImmutableList.of());
        this.assertQuery("SELECT value FROM nonlowercaseschema.nonlowercaseview WHERE name = 'abc'", "SELECT 1");
        this.assertUpdate("DROP TABLE nonlowercaseschema.lowercase_view");
        this.assertUpdate("DROP TABLE test_database.nonlowercaseview");
        this.assertUpdate("DROP TABLE nonlowercaseschema.test_collection");
        this.assertUpdate("DROP TABLE test_database.test_collection");
        this.assertUpdate("DROP TABLE nonlowercaseschema.nonlowercaseview");
    }

    @Test
    public void testNativeQueryWithCaseInSensitiveNameMatch() {
        String tableName = "Test_Case_Insensitive" + TestingNames.randomNameSuffix();
        String schemaName = "Test_Case_Insensitive_Schema" + TestingNames.randomNameSuffix();
        this.client.getDatabase(schemaName).getCollection(tableName).insertOne((Object)new Document("field", (Object)"hello"));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(mongodb.system.query(database => '" + schemaName.toLowerCase(Locale.ENGLISH) + "', collection => '" + tableName.toLowerCase(Locale.ENGLISH) + "', filter => '{}'))"))).matches("VALUES CAST('hello' AS VARCHAR)");
    }
}

