/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.mongodb.MongoClientConfig;
import io.trino.plugin.mongodb.ReadPreferenceType;
import io.trino.plugin.mongodb.WriteConcernType;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestMongoClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MongoClientConfig)ConfigAssertions.recordDefaults(MongoClientConfig.class)).setConnectionUrl(null).setSchemaCollection("_schema").setCaseInsensitiveNameMatching(false).setMinConnectionsPerHost(0).setConnectionsPerHost(100).setMaxWaitTime(120000).setConnectionTimeout(10000).setSocketTimeout(0).setTlsEnabled(false).setMaxConnectionIdleTime(0).setCursorBatchSize(0).setReadPreference(ReadPreferenceType.PRIMARY).setWriteConcern(WriteConcernType.ACKNOWLEDGED).setRequiredReplicaSetName(null).setImplicitRowFieldPrefix("_pos").setProjectionPushdownEnabled(true).setAllowLocalScheduling(false).setDynamicFilteringWaitTimeout(new Duration(5.0, TimeUnit.SECONDS)));
    }

    @Test
    public void testExplicitPropertyMappings() throws Exception {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"mongodb.schema-collection", (Object)"_my_schema").put((Object)"mongodb.case-insensitive-name-matching", (Object)"true").put((Object)"mongodb.connection-url", (Object)"mongodb://router1.example.com:27017,router2.example2.com:27017,router3.example3.com:27017/").put((Object)"mongodb.min-connections-per-host", (Object)"1").put((Object)"mongodb.connections-per-host", (Object)"99").put((Object)"mongodb.max-wait-time", (Object)"120001").put((Object)"mongodb.connection-timeout", (Object)"9999").put((Object)"mongodb.socket-timeout", (Object)"1").put((Object)"mongodb.tls.enabled", (Object)"true").put((Object)"mongodb.max-connection-idle-time", (Object)"180000").put((Object)"mongodb.cursor-batch-size", (Object)"1").put((Object)"mongodb.read-preference", (Object)"NEAREST").put((Object)"mongodb.write-concern", (Object)"UNACKNOWLEDGED").put((Object)"mongodb.required-replica-set", (Object)"replica_set").put((Object)"mongodb.implicit-row-field-prefix", (Object)"_prefix").put((Object)"mongodb.projection-pushdown-enabled", (Object)"false").put((Object)"mongodb.allow-local-scheduling", (Object)"true").put((Object)"mongodb.dynamic-filtering.wait-timeout", (Object)"2ms").buildOrThrow();
        MongoClientConfig expected = new MongoClientConfig().setSchemaCollection("_my_schema").setCaseInsensitiveNameMatching(true).setConnectionUrl("mongodb://router1.example.com:27017,router2.example2.com:27017,router3.example3.com:27017/").setMinConnectionsPerHost(1).setConnectionsPerHost(99).setMaxWaitTime(120001).setConnectionTimeout(9999).setSocketTimeout(1).setTlsEnabled(true).setMaxConnectionIdleTime(180000).setCursorBatchSize(1).setReadPreference(ReadPreferenceType.NEAREST).setWriteConcern(WriteConcernType.UNACKNOWLEDGED).setRequiredReplicaSetName("replica_set").setImplicitRowFieldPrefix("_prefix").setProjectionPushdownEnabled(false).setAllowLocalScheduling(true).setDynamicFilteringWaitTimeout(new Duration(2.0, TimeUnit.MILLISECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

