/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.mongodb.AuthenticatedMongoServer;
import io.trino.plugin.mongodb.MongoPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.Test;

public class TestMongoPrivileges
extends AbstractTestQueryFramework {
    private static final List<String> DATABASES = ImmutableList.of((Object)"db", (Object)"MixedCaseDB", (Object)"UPPERCASEDB");
    private static final String TEST_COLLECTION = "testCollection";

    protected QueryRunner createQueryRunner() throws Exception {
        AuthenticatedMongoServer mongoServer = (AuthenticatedMongoServer)this.closeAfterClass(TestMongoPrivileges.setupMongoServer());
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog(Optional.empty()).setSchema(Optional.empty()).build()).build();
        try {
            queryRunner.installPlugin((Plugin)new MongoPlugin());
            DATABASES.forEach(arg_0 -> TestMongoPrivileges.lambda$createQueryRunner$0(mongoServer, (QueryRunner)queryRunner, arg_0));
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    @Test
    public void testSchemasVisibility() {
        for (String database : DATABASES) {
            this.assertQuery("SHOW SCHEMAS FROM " + TestMongoPrivileges.getCatalogName(database), "VALUES 'information_schema','%s'".formatted(database.toLowerCase(Locale.ENGLISH)));
        }
    }

    @Test
    public void testTablesVisibility() {
        for (String database : DATABASES) {
            this.assertQuery("SHOW TABLES FROM %s.%s".formatted(TestMongoPrivileges.getCatalogName(database), database), "VALUES '%s'".formatted(TEST_COLLECTION.toLowerCase(Locale.ENGLISH)));
        }
    }

    @Test
    public void testSelectFromTable() {
        for (String database : DATABASES) {
            this.assertQuery("SELECT * from %s.%s.%s".formatted(TestMongoPrivileges.getCatalogName(database), database, TEST_COLLECTION), "VALUES ('abc', 1)");
        }
    }

    private static AuthenticatedMongoServer setupMongoServer() {
        AuthenticatedMongoServer mongoServer = new AuthenticatedMongoServer("4.2.0");
        try (MongoClient client = MongoClients.create((ConnectionString)mongoServer.rootUserConnectionString());){
            DATABASES.forEach(database -> TestMongoPrivileges.createDatabase(client, database));
            client.getDatabase("another").createCollection("_schema");
        }
        return mongoServer;
    }

    private static void createDatabase(MongoClient client, String database) {
        MongoDatabase testDatabase = client.getDatabase(database);
        TestMongoPrivileges.runCommand(testDatabase, TestMongoPrivileges.createTestRole(database));
        TestMongoPrivileges.runCommand(testDatabase, TestMongoPrivileges.createTestUser(database));
        testDatabase.createCollection("_schema");
        testDatabase.getCollection(TEST_COLLECTION).insertOne((Object)new Document((Map)ImmutableMap.of((Object)"Name", (Object)"abc", (Object)"Value", (Object)1)));
        testDatabase.createCollection("anotherCollection");
    }

    private static void runCommand(MongoDatabase database, Document document) {
        Double commandStatus = (Double)database.runCommand((Bson)document).get((Object)"ok", Double.class);
        Assertions.assertThat((Double)commandStatus).isEqualTo(1.0);
    }

    private static Document createTestRole(String database) {
        return AuthenticatedMongoServer.createRole(TestMongoPrivileges.getRoleName(database), (List<Document>)ImmutableList.of((Object)AuthenticatedMongoServer.privilege(AuthenticatedMongoServer.resource(database, "_schema"), (List<String>)ImmutableList.of((Object)"find", (Object)"listIndexes", (Object)"createIndex", (Object)"insert")), (Object)AuthenticatedMongoServer.privilege(AuthenticatedMongoServer.resource(database, TEST_COLLECTION), (List<String>)ImmutableList.of((Object)"find", (Object)"listIndexes"))), (List<Object>)ImmutableList.of());
    }

    private static String getCatalogName(String database) {
        return "mongodb_" + database.toLowerCase(Locale.ENGLISH);
    }

    private static Document createTestUser(String database) {
        return AuthenticatedMongoServer.createUser(TestMongoPrivileges.getUsername(database), TestMongoPrivileges.getPassword(database), (List<Document>)ImmutableList.of((Object)AuthenticatedMongoServer.role(database, TestMongoPrivileges.getRoleName(database))));
    }

    private static String getRoleName(String database) {
        return database + "testRole";
    }

    private static String getUsername(String database) {
        return database + "testUser";
    }

    private static String getPassword(String database) {
        return database + "pass";
    }

    private static /* synthetic */ void lambda$createQueryRunner$0(AuthenticatedMongoServer mongoServer, QueryRunner queryRunner, String database) {
        String connectionUrl = mongoServer.testUserConnectionString(database, TestMongoPrivileges.getUsername(database), TestMongoPrivileges.getPassword(database)).getConnectionString();
        queryRunner.createCatalog(TestMongoPrivileges.getCatalogName(database), "mongodb", (Map)ImmutableMap.of((Object)"mongodb.case-insensitive-name-matching", (Object)"true", (Object)"mongodb.connection-url", (Object)connectionUrl));
    }
}

