/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.mongodb.client.MongoClient;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoPlugin;
import io.trino.plugin.mongodb.MongoQueryRunner;
import io.trino.plugin.mongodb.MongoServer;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.BasePushdownPlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinType;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMongoProjectionPushdownPlans
extends BasePushdownPlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final String CATALOG = "mongodb";
    private static final String SCHEMA = "test";
    private final Closer closer = Closer.create();

    protected PlanTester createPlanTester() {
        Session session = TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema(SCHEMA).build();
        PlanTester planTester = PlanTester.create((Session)session);
        MongoServer server = (MongoServer)this.closer.register((Closeable)new MongoServer());
        MongoClient client = (MongoClient)this.closer.register((Closeable)MongoQueryRunner.createMongoClient(server));
        try {
            planTester.installPlugin((Plugin)new MongoPlugin());
            planTester.createCatalog(CATALOG, CATALOG, (Map)ImmutableMap.of((Object)"mongodb.connection-url", (Object)server.getConnectionString().toString()));
            client.getDatabase(SCHEMA).createCollection("dummy");
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{planTester});
            throw e;
        }
        return planTester;
    }

    @AfterAll
    public final void destroy() throws Exception {
        this.closer.close();
    }

    @Test
    public void testPushdownDisabled() {
        String tableName = "test_pushdown_disabled_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setCatalogSessionProperty(CATALOG, "projection_pushdown_enabled", "false").build();
        this.getPlanTester().executeStatement("CREATE TABLE " + tableName + " (col0) AS SELECT CAST(row(5, 6) AS row(a bigint, b bigint)) AS col0 WHERE false");
        this.assertPlan("SELECT col0.a expr_a, col0.b expr_b FROM " + tableName, session, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "col0"), 0)), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "col0"), 1))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)tableName, (Map)ImmutableMap.of((Object)"col0", (Object)"col0")))}));
    }

    @Test
    public void testDereferencePushdown() {
        String tableName = "test_simple_projection_pushdown" + TestingNames.randomNameSuffix();
        QualifiedObjectName completeTableName = new QualifiedObjectName(CATALOG, SCHEMA, tableName);
        this.getPlanTester().executeStatement("CREATE TABLE " + tableName + " (col0, col1) AS SELECT CAST(row(5, 6) AS row(x BIGINT, y BIGINT)) AS col0, BIGINT '5' AS col1");
        Session session = this.getPlanTester().getDefaultSession();
        Optional tableHandle = this.getTableHandle(session, completeTableName);
        ((OptionalAssert)Assertions.assertThat((Optional)tableHandle).as("expected the table handle to be present", new Object[0])).isPresent();
        MongoTableHandle mongoTableHandle = (MongoTableHandle)((TableHandle)tableHandle.get()).connectorHandle();
        Map columns = this.getColumnHandles(session, completeTableName);
        MongoColumnHandle column0Handle = (MongoColumnHandle)columns.get("col0");
        MongoColumnHandle column1Handle = (MongoColumnHandle)columns.get("col1");
        MongoColumnHandle columnX = this.createProjectedColumnHandle(column0Handle, (List<String>)ImmutableList.of((Object)"x"), (Type)BigintType.BIGINT);
        MongoColumnHandle columnY = this.createProjectedColumnHandle(column0Handle, (List<String>)ImmutableList.of((Object)"y"), (Type)BigintType.BIGINT);
        this.assertPlan("SELECT col0.x expr_x, col0.y expr_y FROM " + tableName, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)mongoTableHandle.withProjectedColumns(Set.of(columnX, columnY))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0.x", (Object)Predicates.equalTo((Object)columnX), (Object)"col0.y", (Object)Predicates.equalTo((Object)columnY)))}));
        this.assertPlan("SELECT col0.x FROM " + tableName + " WHERE col0.x = col1 + 3 and col0.y = 2", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "col1"), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L)))), (PlanMatchPattern)PlanMatchPattern.tableScan(table -> {
            MongoTableHandle actualTableHandle = (MongoTableHandle)table;
            TupleDomain constraint = actualTableHandle.constraint();
            return actualTableHandle.projectedColumns().equals(ImmutableSet.of((Object)column1Handle, (Object)columnX)) && constraint.equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnY, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col1", (Object)Predicates.equalTo((Object)column1Handle), (Object)"x", (Object)Predicates.equalTo((Object)columnX))))}));
        this.assertPlan("SELECT col0, col0.y expr_y FROM " + tableName + " WHERE col0.x = 5", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(table -> {
            MongoTableHandle actualTableHandle = (MongoTableHandle)table;
            TupleDomain constraint = actualTableHandle.constraint();
            return actualTableHandle.projectedColumns().equals(ImmutableSet.of((Object)column0Handle, (Object)columnY)) && constraint.equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0", (Object)Predicates.equalTo((Object)column0Handle), (Object)"y", (Object)Predicates.equalTo((Object)columnY)))}));
        this.assertPlan("SELECT T.col0.x, T.col0, T.col0.y FROM " + tableName + " T join " + tableName + " S on T.col1 = S.col1 WHERE T.col0.x = 2", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_0_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER}), "expr_0"), 0)), (Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER}), "expr_0")), (Object)"expr_0_y", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER, IntegerType.INTEGER}), "expr_0"), 1))), (PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("t_expr_1", "s_expr_1").left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(table -> {
            MongoTableHandle actualTableHandle = (MongoTableHandle)table;
            TupleDomain constraint = actualTableHandle.constraint();
            ImmutableSet expectedProjections = ImmutableSet.of((Object)column0Handle, (Object)column1Handle);
            TupleDomain expectedConstraint = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
            return actualTableHandle.projectedColumns().equals(expectedProjections) && constraint.equals((Object)expectedConstraint);
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"expr_0", (Object)Predicates.equalTo((Object)column0Handle), (Object)"t_expr_1", (Object)Predicates.equalTo((Object)column1Handle)))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)mongoTableHandle.withProjectedColumns(Set.of(column1Handle))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"s_expr_1", (Object)Predicates.equalTo((Object)column1Handle)))}))))}));
    }

    @Test
    public void testDereferencePushdownWithDotAndDollarContainingField() {
        String tableName = "test_dereference_pushdown_with_dot_and_dollar_containing_field_" + TestingNames.randomNameSuffix();
        QualifiedObjectName completeTableName = new QualifiedObjectName(CATALOG, SCHEMA, tableName);
        this.getPlanTester().executeStatement("CREATE TABLE " + tableName + " (id, root1) AS SELECT BIGINT '1', CAST(ROW(11, ROW(111, ROW(1111, varchar 'foo', varchar 'bar'))) AS ROW(id BIGINT, root2 ROW(id BIGINT, root3 ROW(id BIGINT, \"dotted.field\" VARCHAR, \"$name\" VARCHAR))))");
        Session session = this.getPlanTester().getDefaultSession();
        Optional tableHandle = this.getTableHandle(session, completeTableName);
        ((OptionalAssert)Assertions.assertThat((Optional)tableHandle).as("expected the table handle to be present", new Object[0])).isPresent();
        MongoTableHandle mongoTableHandle = (MongoTableHandle)((TableHandle)tableHandle.get()).connectorHandle();
        Map columns = this.getColumnHandles(session, completeTableName);
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"id", (Type)BigintType.BIGINT), RowType.field((String)"dotted.field", (Type)VarcharType.VARCHAR), RowType.field((String)"$name", (Type)VarcharType.VARCHAR)});
        MongoColumnHandle columnRoot1 = (MongoColumnHandle)columns.get("root1");
        MongoColumnHandle columnRoot3 = this.createProjectedColumnHandle(columnRoot1, (List<String>)ImmutableList.of((Object)"root2", (Object)"root3"), (Type)rowType);
        this.assertPlan("SELECT root1.root2.root3.\"dotted.field\" FROM " + tableName, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)mongoTableHandle.withProjectedColumns(Set.of(columnRoot3))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"root1.root2.root3", (Object)Predicates.equalTo((Object)columnRoot3)))}));
        this.assertPlan("SELECT root1.root2.root3.\"$name\" FROM " + tableName, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)mongoTableHandle.withProjectedColumns(Set.of(columnRoot3))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"root1.root2.root3", (Object)Predicates.equalTo((Object)columnRoot3)))}));
        this.assertPlan("SELECT 1 FROM " + tableName + " WHERE root1.root2.root3.\"dotted.field\" = 'foo'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(table -> {
            MongoTableHandle actualTableHandle = (MongoTableHandle)table;
            TupleDomain constraint = actualTableHandle.constraint();
            return actualTableHandle.projectedColumns().equals(ImmutableSet.of((Object)columnRoot3)) && constraint.equals((Object)TupleDomain.all());
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"root1.root2.root3", (Object)Predicates.equalTo((Object)columnRoot3)))}));
        this.assertPlan("SELECT 1 FROM " + tableName + " WHERE root1.root2.root3.\"$name\" = 'bar'", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(table -> {
            MongoTableHandle actualTableHandle = (MongoTableHandle)table;
            TupleDomain constraint = actualTableHandle.constraint();
            return actualTableHandle.projectedColumns().equals(ImmutableSet.of((Object)columnRoot3)) && constraint.equals((Object)TupleDomain.all());
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"root1.root2.root3", (Object)Predicates.equalTo((Object)columnRoot3)))}));
    }

    private MongoColumnHandle createProjectedColumnHandle(MongoColumnHandle baseColumnHandle, List<String> dereferenceNames, Type type) {
        return new MongoColumnHandle(baseColumnHandle.baseName(), dereferenceNames, type, baseColumnHandle.hidden(), baseColumnHandle.dbRefField(), baseColumnHandle.comment());
    }
}

