/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bson.Document;
import org.junit.jupiter.api.Test;

public class TestMongoSession {
    private static final MongoColumnHandle COL1 = TestMongoSession.createColumnHandle("col1", (Type)BigintType.BIGINT, new String[0]);
    private static final MongoColumnHandle COL2 = TestMongoSession.createColumnHandle("col2", (Type)VarcharType.createUnboundedVarcharType(), new String[0]);
    private static final MongoColumnHandle COL3 = TestMongoSession.createColumnHandle("col3", (Type)VarcharType.createUnboundedVarcharType(), new String[0]);
    private static final MongoColumnHandle COL4 = TestMongoSession.createColumnHandle("col4", (Type)BooleanType.BOOLEAN, new String[0]);
    private static final MongoColumnHandle COL5 = TestMongoSession.createColumnHandle("col5", (Type)BigintType.BIGINT, new String[0]);
    private static final MongoColumnHandle COL6 = TestMongoSession.createColumnHandle("grandparent", (Type)VarcharType.createUnboundedVarcharType(), "parent", "col6");
    private static final MongoColumnHandle ID_COL = new MongoColumnHandle("_id", (List)ImmutableList.of(), (Type)ObjectIdType.OBJECT_ID, false, false, Optional.empty());

    @Test
    public void testBuildProjectionWithoutId() {
        ImmutableList columns = ImmutableList.of((Object)COL1, (Object)COL2);
        Document output = MongoSession.buildProjection((List)columns);
        Document expected = new Document().append(COL1.baseName(), (Object)1).append(COL2.baseName(), (Object)1).append(ID_COL.baseName(), (Object)0);
        Assertions.assertThat((Map)output).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildProjectionWithId() {
        ImmutableList columns = ImmutableList.of((Object)COL1, (Object)COL2, (Object)ID_COL);
        Document output = MongoSession.buildProjection((List)columns);
        Document expected = new Document().append(COL1.baseName(), (Object)1).append(COL2.baseName(), (Object)1).append(ID_COL.baseName(), (Object)1);
        Assertions.assertThat((Map)output).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildQuery() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)false, (Object)200L, (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)COL2, (Object)Domain.singleValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"a value"))));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document().append("$and", (Object)ImmutableList.of((Object)new Document(COL1.baseName(), (Object)new Document().append("$gt", (Object)100L).append("$lte", (Object)200L)), (Object)new Document(COL2.baseName(), (Object)new Document("$eq", (Object)"a value"))));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildQueryStringType() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL3, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"hello"), (boolean)false, (Object)Slices.utf8Slice((String)"world"), (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)COL2, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"a value")), (Range[])new Range[0]), (boolean)false)));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document().append("$and", (Object)ImmutableList.of((Object)new Document(COL3.baseName(), (Object)new Document().append("$gt", (Object)"hello").append("$lte", (Object)"world")), (Object)new Document(COL2.baseName(), (Object)new Document("$gte", (Object)"a value"))));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildQueryIn() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL2, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"hello")), (Range[])new Range[]{Range.equal((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"world"))}), (boolean)false)));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document(COL2.baseName(), (Object)new Document("$in", (Object)ImmutableList.of((Object)"hello", (Object)"world")));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildQueryOr() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)100L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)200L)}), (boolean)false)));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document("$or", Arrays.asList(new Document(COL1.baseName(), (Object)new Document("$lt", (Object)100L)), new Document(COL1.baseName(), (Object)new Document("$gt", (Object)200L))));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildQueryNull() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), (Range[])new Range[0]), (boolean)true)));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document("$or", Arrays.asList(new Document(COL1.baseName(), (Object)new Document("$gt", (Object)200L)), new Document(COL1.baseName(), (Object)new Document("$eq", null))));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testBooleanPredicatePushdown() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL4, (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true)));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document().append(COL4.baseName(), (Object)new Document("$eq", (Object)true));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testBuildQueryNestedField() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)COL5, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), (Range[])new Range[0]), (boolean)true), (Object)COL6, (Object)Domain.singleValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"a value"))));
        Document query = MongoSession.buildQuery((TupleDomain)tupleDomain);
        Document expected = new Document().append("$and", (Object)ImmutableList.of((Object)new Document("$or", Arrays.asList(new Document(COL5.getQualifiedName(), (Object)new Document("$gt", (Object)200L)), new Document(COL5.getQualifiedName(), (Object)new Document("$eq", null)))), (Object)new Document(COL6.getQualifiedName(), (Object)new Document("$eq", (Object)"a value"))));
        Assertions.assertThat((Map)query).isEqualTo((Object)expected);
    }

    @Test
    public void testProjectSufficientColumns() {
        MongoColumnHandle col1 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "a", "b");
        MongoColumnHandle col2 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "b");
        MongoColumnHandle col3 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "c");
        MongoColumnHandle col4 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, new String[0]);
        List output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col1, (Object)col2, (Object)col4));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col4})).hasSize(1);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col4, (Object)col2, (Object)col1));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col4})).hasSize(1);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col2, (Object)col1, (Object)col4));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col4})).hasSize(1);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col2, (Object)col3));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col2, col3})).hasSize(2);
        MongoColumnHandle col5 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "a", "b", "c");
        MongoColumnHandle col6 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "a", "c", "b");
        MongoColumnHandle col7 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "c", "a", "b");
        MongoColumnHandle col8 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, "b", "a");
        MongoColumnHandle col9 = TestMongoSession.createColumnHandle("x", (Type)BigintType.BIGINT, new String[0]);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col5, (Object)col6));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col5, col6})).hasSize(2);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col6, (Object)col7));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col6, col7})).hasSize(2);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col5, (Object)col8));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col8, col5})).hasSize(2);
        output = MongoSession.projectSufficientColumns((List)ImmutableList.of((Object)col5, (Object)col6, (Object)col7, (Object)col8, (Object)col9));
        ((ListAssert)Assertions.assertThat((List)output).containsExactly((Object[])new MongoColumnHandle[]{col9})).hasSize(1);
    }

    private static MongoColumnHandle createColumnHandle(String baseName, Type type, String ... dereferenceNames) {
        return new MongoColumnHandle(baseName, (List)ImmutableList.copyOf((Object[])dereferenceNames), type, false, false, Optional.empty());
    }
}

