/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMongoTableHandle {
    private final JsonCodec<MongoTableHandle> codec;

    public TestMongoTableHandle() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        this.codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(MongoTableHandle.class);
    }

    @Test
    public void testRoundTripWithoutQuery() {
        SchemaTableName schemaTableName = new SchemaTableName("schema", "table");
        RemoteTableName remoteTableName = new RemoteTableName("schema", "table");
        MongoTableHandle expected = new MongoTableHandle(schemaTableName, remoteTableName, Optional.empty());
        String json = this.codec.toJson((Object)expected);
        MongoTableHandle actual = (MongoTableHandle)this.codec.fromJson(json);
        Assertions.assertThat((Object)actual.schemaTableName()).isEqualTo((Object)expected.schemaTableName());
    }

    @Test
    public void testRoundTripNonLowercaseWithoutQuery() {
        SchemaTableName schemaTableName = new SchemaTableName("schema", "table");
        RemoteTableName remoteTableName = new RemoteTableName("Schema", "Table");
        MongoTableHandle expected = new MongoTableHandle(schemaTableName, remoteTableName, Optional.empty());
        String json = this.codec.toJson((Object)expected);
        MongoTableHandle actual = (MongoTableHandle)this.codec.fromJson(json);
        Assertions.assertThat((Object)actual.schemaTableName()).isEqualTo((Object)expected.schemaTableName());
    }

    @Test
    public void testRoundTripWithQuery() {
        SchemaTableName schemaTableName = new SchemaTableName("schema", "table");
        RemoteTableName remoteTableName = new RemoteTableName("schema", "table");
        MongoTableHandle expected = new MongoTableHandle(schemaTableName, remoteTableName, Optional.of("{\"key\": \"value\"}"));
        String json = this.codec.toJson((Object)expected);
        MongoTableHandle actual = (MongoTableHandle)this.codec.fromJson(json);
        Assertions.assertThat((Object)actual.schemaTableName()).isEqualTo((Object)expected.schemaTableName());
    }

    @Test
    public void testRoundTripWithQueryHavingHelperFunction() {
        SchemaTableName schemaTableName = new SchemaTableName("schema", "table");
        RemoteTableName remoteTableName = new RemoteTableName("schema", "table");
        MongoTableHandle expected = new MongoTableHandle(schemaTableName, remoteTableName, Optional.of("{timestamp: ISODate(\"2023-03-20T01:02:03.000Z\")}"));
        String json = this.codec.toJson((Object)expected);
        MongoTableHandle actual = (MongoTableHandle)this.codec.fromJson(json);
        Assertions.assertThat((Object)actual.schemaTableName()).isEqualTo((Object)expected.schemaTableName());
    }

    @Test
    public void testRoundTripWithProjectedColumns() {
        SchemaTableName schemaTableName = new SchemaTableName("schema", "table");
        RemoteTableName remoteTableName = new RemoteTableName("Schema", "Table");
        ImmutableSet projectedColumns = ImmutableSet.of((Object)new MongoColumnHandle("id", (List)ImmutableList.of(), (Type)IntegerType.INTEGER, false, false, Optional.empty()), (Object)new MongoColumnHandle("address", (List)ImmutableList.of((Object)"street"), (Type)VarcharType.VARCHAR, false, false, Optional.empty()), (Object)new MongoColumnHandle("user", (List)ImmutableList.of(), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("first"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("last"), (Type)VarcharType.VARCHAR))), false, false, Optional.empty()), (Object)new MongoColumnHandle("creator", (List)ImmutableList.of((Object)"databasename"), (Type)VarcharType.VARCHAR, false, true, Optional.empty()));
        MongoTableHandle expected = new MongoTableHandle(schemaTableName, remoteTableName, Optional.empty(), TupleDomain.all(), (Set)projectedColumns, OptionalInt.empty());
        String json = this.codec.toJson((Object)expected);
        MongoTableHandle actual = (MongoTableHandle)this.codec.fromJson(json);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

