/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.mongodb.MongoTlsConfig;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestMongoTlsConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MongoTlsConfig)ConfigAssertions.recordDefaults(MongoTlsConfig.class)).setKeystorePath(null).setKeystorePassword(null).setTruststorePath(null).setTruststorePassword(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws Exception {
        Path keystoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path truststoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"mongodb.tls.keystore-path", (Object)keystoreFile.toString()).put((Object)"mongodb.tls.keystore-password", (Object)"keystore-password").put((Object)"mongodb.tls.truststore-path", (Object)truststoreFile.toString()).put((Object)"mongodb.tls.truststore-password", (Object)"truststore-password").buildOrThrow();
        MongoTlsConfig expected = new MongoTlsConfig().setKeystorePath(keystoreFile.toFile()).setKeystorePassword("keystore-password").setTruststorePath(truststoreFile.toFile()).setTruststorePassword("truststore-password");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

