/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClients;
import io.trino.Session;
import io.trino.plugin.mongodb.MongoCreateAndInsertDataSetup;
import io.trino.plugin.mongodb.MongoQueryRunner;
import io.trino.plugin.mongodb.MongoServer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.CreateAsSelectDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import io.trino.type.JsonType;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMongoTypeMapping
extends AbstractTestQueryFramework {
    private MongoServer server;

    protected QueryRunner createQueryRunner() throws Exception {
        this.server = (MongoServer)this.closeAfterClass(new MongoServer());
        return MongoQueryRunner.builder(this.server).build();
    }

    @Test
    public void testBoolean() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "true", (Type)BooleanType.BOOLEAN, "true").addRoundTrip("boolean", "false", (Type)BooleanType.BOOLEAN, "false").addRoundTrip("boolean", "NULL", (Type)BooleanType.BOOLEAN, "CAST(NULL AS BOOLEAN)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_boolean")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_boolean"));
        SqlDataTypeTest.create().addRoundTrip("true", "true").addRoundTrip("false", "false").execute(this.getQueryRunner(), this.mongoCreateAndInsert(this.getSession(), "tpch", "test_boolean"));
    }

    @Test
    public void testTinyint() {
        SqlDataTypeTest.create().addRoundTrip("tinyint", "NULL", (Type)TinyintType.TINYINT, "CAST(NULL AS TINYINT)").addRoundTrip("tinyint", "-128", (Type)TinyintType.TINYINT, "TINYINT '-128'").addRoundTrip("tinyint", "5", (Type)TinyintType.TINYINT, "TINYINT '5'").addRoundTrip("tinyint", "127", (Type)TinyintType.TINYINT, "TINYINT '127'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_tinyint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_tinyint"));
    }

    @Test
    public void testSmallint() {
        SqlDataTypeTest.create().addRoundTrip("smallint", "NULL", (Type)SmallintType.SMALLINT, "CAST(NULL AS SMALLINT)").addRoundTrip("smallint", "-32768", (Type)SmallintType.SMALLINT, "SMALLINT '-32768'").addRoundTrip("smallint", "32456", (Type)SmallintType.SMALLINT, "SMALLINT '32456'").addRoundTrip("smallint", "32767", (Type)SmallintType.SMALLINT, "SMALLINT '32767'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_smallint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_smallint"));
    }

    @Test
    public void testInteger() {
        SqlDataTypeTest.create().addRoundTrip("integer", "NULL", (Type)IntegerType.INTEGER, "CAST(NULL AS INTEGER)").addRoundTrip("integer", "-2147483648", (Type)IntegerType.INTEGER, "-2147483648").addRoundTrip("integer", "1234567890", (Type)IntegerType.INTEGER, "1234567890").addRoundTrip("integer", "2147483647", (Type)IntegerType.INTEGER, "2147483647").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_int")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_int"));
        SqlDataTypeTest.create().addRoundTrip("-2147483648", "BIGINT '-2147483648'").addRoundTrip("0", "BIGINT '0'").addRoundTrip("2147483647", "BIGINT '2147483647'").execute(this.getQueryRunner(), this.mongoCreateAndInsert(this.getSession(), "tpch", "test_int"));
    }

    @Test
    public void testBigint() {
        SqlDataTypeTest.create().addRoundTrip("bigint", "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").addRoundTrip("bigint", "-9223372036854775808", (Type)BigintType.BIGINT, "-9223372036854775808").addRoundTrip("bigint", "123456789012", (Type)BigintType.BIGINT, "123456789012").addRoundTrip("bigint", "9223372036854775807", (Type)BigintType.BIGINT, "9223372036854775807").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_bigint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_bigint"));
    }

    @Test
    public void testMongoNumberLong() {
        SqlDataTypeTest.create().addRoundTrip("NumberLong(-9223372036854775808)", "BIGINT '-9223372036854775808'").addRoundTrip("NumberLong(9223372036854775807)", "BIGINT '9223372036854775807'").execute(this.getQueryRunner(), this.mongoCreateAndInsert(this.getSession(), "tpch", "test_number_long"));
    }

    @Test
    public void testDouble() {
        SqlDataTypeTest.create().addRoundTrip("double", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("double", "nan()", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("double", "+infinity()", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("double", "-infinity()", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_double")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("trino_test_double"));
    }

    @Test
    public void testDecimal() {
        SqlDataTypeTest.create().addRoundTrip("decimal(3, 0)", "CAST('193' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('193' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('19' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('19' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('-193' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('-193' AS decimal(3, 0))").addRoundTrip("decimal(3, 1)", "CAST('10.0' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.0' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "CAST('10.1' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.1' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "CAST('-10.1' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('-10.1' AS decimal(3, 1))").addRoundTrip("decimal(4, 2)", "CAST('2' AS decimal(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2' AS decimal(4, 2))").addRoundTrip("decimal(4, 2)", "CAST('2.3' AS decimal(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2.3' AS decimal(4, 2))").addRoundTrip("decimal(24, 2)", "CAST('2' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "CAST('2.3' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "CAST('123456789.3' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('123456789.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 4)", "CAST('12345678901234567890.31' AS decimal(24, 4))", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST('12345678901234567890.31' AS decimal(24, 4))").addRoundTrip("decimal(30, 5)", "CAST('3141592653589793238462643.38327' AS decimal(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(30, 5)", "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(3, 0)", "CAST(NULL AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(NULL AS decimal(3, 0))").addRoundTrip("decimal(38, 0)", "CAST(NULL AS decimal(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST(NULL AS decimal(38, 0))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_decimal")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_decimal"));
        SqlDataTypeTest.create().addRoundTrip("NumberDecimal(\"2\")", "CAST('2' AS decimal(1, 0))").addRoundTrip("NumberDecimal(\"2.3\")", "CAST('2.3' AS decimal(2, 1))").addRoundTrip("NumberDecimal(\"-2.3\")", "CAST('-2.3' AS decimal(2, 1))").addRoundTrip("NumberDecimal(\"0.03\")", "CAST('0.03' AS decimal(2, 2))").addRoundTrip("NumberDecimal(\"-0.03\")", "CAST('-0.03' AS decimal(2, 2))").addRoundTrip("NumberDecimal(\"1234567890123456789012345678901234\")", "CAST('1234567890123456789012345678901234' AS decimal(34, 0))").addRoundTrip("NumberDecimal(\"1234567890123456.789012345678901234\")", "CAST('1234567890123456.789012345678901234' AS decimal(34, 18))").execute(this.getQueryRunner(), this.mongoCreateAndInsert(this.getSession(), "tpch", "test_decimal"));
    }

    @Test
    public void testChar() {
        SqlDataTypeTest.create().addRoundTrip("char", "''", (Type)CharType.createCharType((int)1), "CAST('' AS char(1))").addRoundTrip("char", "'a'", (Type)CharType.createCharType((int)1), "CAST('a' AS char(1))").addRoundTrip("char(1)", "''", (Type)CharType.createCharType((int)1), "CAST('' AS char(1))").addRoundTrip("char(1)", "'a'", (Type)CharType.createCharType((int)1), "CAST('a' AS char(1))").addRoundTrip("char(8)", "'abc'", (Type)CharType.createCharType((int)8), "CAST('abc' AS char(8))").addRoundTrip("char(8)", "'12345678'", (Type)CharType.createCharType((int)8), "CAST('12345678' AS char(8))").addRoundTrip("char(255)", String.format("'%s'", "a".repeat(255)), (Type)CharType.createCharType((int)255), String.format("CAST('%s' AS char(255))", "a".repeat(255))).addRoundTrip("char(1)", "'\u653b'", (Type)CharType.createCharType((int)1), "CAST('\u653b' AS char(1))").addRoundTrip("char(5)", "'\u653b\u6bbb'", (Type)CharType.createCharType((int)5), "CAST('\u653b\u6bbb' AS char(5))").addRoundTrip("char(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(5))").addRoundTrip("char", "NULL", (Type)CharType.createCharType((int)1), "CAST(NULL AS char(1))").addRoundTrip("char(255)", "NULL", (Type)CharType.createCharType((int)255), "CAST(NULL AS char(255))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_char")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_char"));
    }

    @Test
    public void testVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar(10)", "'text_a'", (Type)VarcharType.createVarcharType((int)10), "CAST('text_a' AS VARCHAR(10))").addRoundTrip("varchar(255)", "'text_b'", (Type)VarcharType.createVarcharType((int)255), "CAST('text_b' AS VARCHAR(255))").addRoundTrip("varchar(65535)", "'text_d'", (Type)VarcharType.createVarcharType((int)65535), "CAST('text_d' AS VARCHAR(65535))").addRoundTrip("varchar(10485760)", "'text_f'", (Type)VarcharType.createVarcharType((int)0xA00000), "CAST('text_f' AS VARCHAR(10485760))").addRoundTrip("varchar", "'unbounded'", (Type)VarcharType.VARCHAR, "VARCHAR 'unbounded'").addRoundTrip("varchar(10)", "NULL", (Type)VarcharType.createVarcharType((int)10), "CAST(NULL AS VARCHAR(10))").addRoundTrip("varchar", "NULL", (Type)VarcharType.VARCHAR, "CAST(NULL AS VARCHAR)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varchar")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_varchar"));
        SqlDataTypeTest.create().addRoundTrip("'unbounded'", "VARCHAR 'unbounded'").addRoundTrip("''", "VARCHAR ''").execute(this.getQueryRunner(), this.mongoCreateAndInsert(this.getSession(), "tpch", "test_varchar"));
    }

    @Test
    public void testVarbinary() {
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "to_utf8('')").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varbinary")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_varbinary"));
    }

    @Test
    public void testTime() {
        SqlDataTypeTest.create().addRoundTrip("time", "NULL", (Type)TimeType.createTimeType((int)3), "CAST(NULL AS TIME)").addRoundTrip("time", "TIME '00:00:00'", (Type)TimeType.createTimeType((int)3), "TIME '00:00:00.000'").addRoundTrip("time", "TIME '23:59:59'", (Type)TimeType.createTimeType((int)3), "TIME '23:59:59.000'").addRoundTrip("time", "TIME '23:59:59.9'", (Type)TimeType.createTimeType((int)3), "TIME '23:59:59.900'").addRoundTrip("time", "TIME '23:59:59.99'", (Type)TimeType.createTimeType((int)3), "TIME '23:59:59.990'").addRoundTrip("time", "TIME '23:59:59.999'", (Type)TimeType.createTimeType((int)3), "TIME '23:59:59.999'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_time")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_time"));
    }

    @Test
    public void testDate() {
        this.testDate(ZoneOffset.UTC);
        this.testDate(ZoneId.systemDefault());
        this.testDate(ZoneId.of("Europe/Vilnius"));
        this.testDate(ZoneId.of("Asia/Kathmandu"));
        this.testDate(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testDate(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("date", "NULL", (Type)DateType.DATE, "CAST(NULL AS DATE)").addRoundTrip("date", "DATE '-5877641-06-23'", (Type)DateType.DATE, "DATE '-5877641-06-23'").addRoundTrip("date", "DATE '-0001-01-01'", (Type)DateType.DATE, "DATE '-0001-01-01'").addRoundTrip("date", "DATE '0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "DATE '0012-12-12'", (Type)DateType.DATE, "DATE '0012-12-12'").addRoundTrip("date", "DATE '1500-01-01'", (Type)DateType.DATE, "DATE '1500-01-01'").addRoundTrip("date", "DATE '1582-10-04'", (Type)DateType.DATE, "DATE '1582-10-04'").addRoundTrip("date", "DATE '1582-10-05'", (Type)DateType.DATE, "DATE '1582-10-05'").addRoundTrip("date", "DATE '1582-10-14'", (Type)DateType.DATE, "DATE '1582-10-14'").addRoundTrip("date", "DATE '1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "DATE '1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "DATE '1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'").addRoundTrip("date", "DATE '2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "DATE '2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "DATE '9999-12-31'", (Type)DateType.DATE, "DATE '9999-12-31'").addRoundTrip("date", "DATE '19999-12-31'", (Type)DateType.DATE, "DATE '19999-12-31'").addRoundTrip("date", "DATE '5881580-07-11'", (Type)DateType.DATE, "DATE '5881580-07-11'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_date"));
    }

    @Test
    public void testTimestamp() {
        this.testTimestamp(ZoneOffset.UTC);
        this.testTimestamp(ZoneId.systemDefault());
        this.testTimestamp(ZoneId.of("Europe/Vilnius"));
        this.testTimestamp(ZoneId.of("Asia/Kathmandu"));
        this.testTimestamp(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testTimestamp(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("timestamp '-290307-12-31 23:59:59.999'", "timestamp '-290307-12-31 23:59:59.999'").addRoundTrip("timestamp '1582-10-04 23:59:59.999'", "timestamp '1582-10-04 23:59:59.999'").addRoundTrip("timestamp '1582-10-05 00:00:00.000'", "timestamp '1582-10-05 00:00:00.000'").addRoundTrip("timestamp '1582-10-14 23:59:59.999'", "timestamp '1582-10-14 23:59:59.999'").addRoundTrip("timestamp '1970-01-01 00:00:00.000'", "timestamp '1970-01-01 00:00:00.000'").addRoundTrip("timestamp '1986-01-01 00:13:07.123'", "timestamp '1986-01-01 00:13:07.123'").addRoundTrip("timestamp '2018-03-25 03:17:17.123'", "timestamp '2018-03-25 03:17:17.123'").addRoundTrip("timestamp '2018-10-28 01:33:17.456'", "timestamp '2018-10-28 01:33:17.456'").addRoundTrip("timestamp '2018-10-28 03:33:33.333'", "timestamp '2018-10-28 03:33:33.333'").addRoundTrip("timestamp '294247-01-10 04:00:54.775'", "timestamp '294247-01-10 04:00:54.775'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_timestamp"));
    }

    @Test
    public void testTimestampWithTimeZoneMapping() {
        this.testTimestampWithTimeZoneMapping(ZoneOffset.UTC);
        this.testTimestampWithTimeZoneMapping(ZoneId.systemDefault());
        this.testTimestampWithTimeZoneMapping(ZoneId.of("Europe/Vilnius"));
        this.testTimestampWithTimeZoneMapping(ZoneId.of("Asia/Kathmandu"));
        this.testTimestampWithTimeZoneMapping(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testTimestampWithTimeZoneMapping(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("timestamp '-69387-04-22 03:45:14.752 UTC'", "timestamp '-69387-04-22 03:45:14.752 UTC'").addRoundTrip("timestamp '1582-10-04 23:59:59.999 UTC'", "timestamp '1582-10-04 23:59:59.999 UTC'").addRoundTrip("timestamp '1582-10-05 00:00:00.000 UTC'", "timestamp '1582-10-05 00:00:00.000 UTC'").addRoundTrip("timestamp '1582-10-14 23:59:59.999 UTC'", "timestamp '1582-10-14 23:59:59.999 UTC'").addRoundTrip("timestamp '1970-01-01 00:00:00.000 UTC'", "timestamp '1970-01-01 00:00:00.000 UTC'").addRoundTrip("timestamp '1986-01-01 00:13:07.123 UTC'", "timestamp '1986-01-01 00:13:07.123 UTC'").addRoundTrip("timestamp '2018-03-25 03:17:17.123 UTC'", "timestamp '2018-03-25 03:17:17.123 UTC'").addRoundTrip("timestamp '2018-10-28 01:33:17.456 UTC'", "timestamp '2018-10-28 01:33:17.456 UTC'").addRoundTrip("timestamp '2018-10-28 03:33:33.333 UTC'", "timestamp '2018-10-28 03:33:33.333 UTC'").addRoundTrip("timestamp '2022-10-01 22:30:00.000 -01:30'", "timestamp '2022-10-02 00:00:00.000 UTC'").addRoundTrip("timestamp '2022-10-02 01:30:00.000 +01:30'", "timestamp '2022-10-02 00:00:00.000 UTC'").addRoundTrip("timestamp '73326-09-11 20:14:45.247 UTC'", "timestamp '73326-09-11 20:14:45.247 UTC'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_timestamp_with_time_zone")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_timestamp_with_time_zone")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_timestamp_with_time_zone")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_timestamp_with_time_zone"));
    }

    @Test
    public void testArray() {
        SqlDataTypeTest.create().addRoundTrip("ARRAY(boolean)", "ARRAY[true, false]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "ARRAY[true, false]").addRoundTrip("ARRAY(bigint)", "ARRAY[123456789012]", (Type)new ArrayType((Type)BigintType.BIGINT), "ARRAY[123456789012]").addRoundTrip("ARRAY(integer)", "ARRAY[1, 2, 1234567890]", (Type)new ArrayType((Type)IntegerType.INTEGER), "ARRAY[1, 2, 1234567890]").addRoundTrip("ARRAY(smallint)", "ARRAY[32456]", (Type)new ArrayType((Type)SmallintType.SMALLINT), "ARRAY[SMALLINT '32456']").addRoundTrip("ARRAY(double)", "ARRAY[123.45]", (Type)new ArrayType((Type)DoubleType.DOUBLE), "ARRAY[DOUBLE '123.45']").addRoundTrip("ARRAY(real)", "ARRAY[123.45]", (Type)new ArrayType((Type)RealType.REAL), "ARRAY[REAL '123.45']").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_array")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_array"));
    }

    @Test
    public void testArrayNulls() {
        try (TestTable table = this.newTrinoTable("test_array_nulls", "(c1 ARRAY(boolean), c2 ARRAY(varchar), c3 ARRAY(varchar))", (List)ImmutableList.of((Object)"(NULL, ARRAY[NULL], ARRAY['foo', NULL, 'bar', NULL])"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT c1 FROM " + table.getName()))).matches("VALUES CAST(NULL AS ARRAY(boolean))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT c2 FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL] AS ARRAY(varchar))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT c3 FROM " + table.getName()))).matches("VALUES CAST(ARRAY['foo', NULL, 'bar', NULL] AS ARRAY(varchar))");
        }
    }

    @Test
    public void testJson() {
        SqlDataTypeTest.create().addRoundTrip("json", "json '{\"id\":0,\"name\":\"user_0\"}'", (Type)JsonType.JSON, "json '{\"id\":0,\"name\":\"user_0\"}'").addRoundTrip("json", "json '{}'", (Type)JsonType.JSON, "json '{}'").addRoundTrip("json", "CAST(NULL AS json)", (Type)JsonType.JSON, "CAST(NULL AS json)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_json")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_json"));
    }

    private DataSetup trinoCreateAsSelect(String tableNamePrefix) {
        return this.trinoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(String tableNamePrefix) {
        return this.trinoCreateAndInsert(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(Session session, String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup mongoCreateAndInsert(Session session, String databaseName, String tableNamePrefix) {
        return new MongoCreateAndInsertDataSetup(new TrinoSqlExecutor(this.getQueryRunner(), session), MongoClients.create((ConnectionString)this.server.getConnectionString()), databaseName, tableNamePrefix);
    }
}

