/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import io.trino.plugin.mongodb.MongoPlugin;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.spi.Plugin;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.bson.types.ObjectId;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestObjectIdFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addPlugin((Plugin)new MongoPlugin());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testObjectid() {
        ((QueryAssertions.ExpressionAssert)Assertions.assertThat((AssertProvider)this.assertions.function("ObjectId", new String[]{"'1234567890abcdef12345678'"}))).hasType((Type)ObjectIdType.OBJECT_ID).isEqualTo((Object)new SqlVarbinary(new ObjectId("1234567890abcdef12345678").toByteArray()));
    }

    @Test
    public void testObjectidIgnoresSpaces() {
        ((QueryAssertions.ExpressionAssert)Assertions.assertThat((AssertProvider)this.assertions.function("ObjectId", new String[]{"'12 34 56 78 90 ab cd ef   12 34 56 78'"}))).hasType((Type)ObjectIdType.OBJECT_ID).isEqualTo((Object)new SqlVarbinary(new ObjectId("1234567890abcdef12345678").toByteArray()));
    }

    @Test
    public void testObjectidTimestamp() {
        ((QueryAssertions.ExpressionAssert)Assertions.assertThat((AssertProvider)this.assertions.function("objectid_timestamp", new String[]{"ObjectId('1234567890abcdef12345678')"}))).hasType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).isEqualTo((Object)this.toTimestampWithTimeZone(ZonedDateTime.of(1979, 9, 5, 22, 51, 36, 0, ZoneOffset.UTC)));
    }

    @Test
    public void testTimestampObjectid() {
        ((QueryAssertions.ExpressionAssert)Assertions.assertThat((AssertProvider)this.assertions.function("timestamp_objectid", new String[]{"TIMESTAMP '1979-09-05 22:51:36 +00:00'"}))).hasType((Type)ObjectIdType.OBJECT_ID).isEqualTo((Object)new SqlVarbinary(new ObjectId("123456780000000000000000").toByteArray()));
    }

    @Test
    public void testTimestampObjectidNull() {
        ((QueryAssertions.ExpressionAssert)Assertions.assertThat((AssertProvider)this.assertions.function("timestamp_objectid", new String[]{"null"}))).isNull((Type)ObjectIdType.OBJECT_ID);
    }

    private SqlTimestampWithTimeZone toTimestampWithTimeZone(ZonedDateTime zonedDateTime) {
        return SqlTimestampWithTimeZone.newInstance((int)3, (long)zonedDateTime.toInstant().toEpochMilli(), (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)zonedDateTime.getZone().getId()));
    }
}

