/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import com.google.common.io.Closer;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.plugin.base.TemporaryTables;
import io.trino.plugin.base.projection.ApplyProjectionUtil;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoIndex;
import io.trino.plugin.mongodb.MongoInsertTableHandle;
import io.trino.plugin.mongodb.MongoOutputTableHandle;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoSessionProperties;
import io.trino.plugin.mongodb.MongoTable;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.plugin.mongodb.TypeUtils;
import io.trino.plugin.mongodb.ptf.Query;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(MongoMetadata.class);
    private static final Type TRINO_PAGE_SINK_ID_COLUMN_TYPE = BigintType.BIGINT;
    private static final int MAX_QUALIFIED_IDENTIFIER_BYTE_LENGTH = 120;
    private final MongoSession mongoSession;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public MongoMetadata(MongoSession mongoSession) {
        this.mongoSession = Objects.requireNonNull(mongoSession, "mongoSession is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.mongoSession.getAllSchemas();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        this.mongoSession.createSchema(schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        this.mongoSession.dropSchema(schemaName, cascade);
    }

    public MongoTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        Objects.requireNonNull(tableName, "tableName is null");
        try {
            return this.mongoSession.getTable(tableName).tableHandle();
        }
        catch (TableNotFoundException e) {
            log.debug((Throwable)e, "Table(%s) not found", new Object[]{tableName});
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = MongoMetadata.getTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        List schemaNames = (List)optionalSchemaName.map(ImmutableList::of).orElseGet(() -> (ImmutableList)this.listSchemaNames(session));
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : schemaNames) {
            for (String tableName : this.mongoSession.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase(Locale.ENGLISH)));
            }
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        List<MongoColumnHandle> columns = this.mongoSession.getTable(table.schemaTableName()).columns();
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (MongoColumnHandle columnHandle : columns) {
            columnHandles.put((Object)columnHandle.baseName().toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        return columnHandles.buildOrThrow();
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        HashMap<SchemaTableName, RelationColumnsMetadata> relationColumns = new HashMap<SchemaTableName, RelationColumnsMetadata>();
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                relationColumns.put(tableName, RelationColumnsMetadata.forTable((SchemaTableName)tableName, (List)this.getTableMetadata(tableName).getColumns()));
            }
            catch (NotFoundException notFoundException) {}
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((MongoColumnHandle)columnHandle).toColumnMetadata();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        RemoteTableName remoteTableName = this.mongoSession.toRemoteSchemaTableName(tableMetadata.getTable());
        this.mongoSession.createTable(remoteTableName, MongoMetadata.buildColumnHandles(tableMetadata), tableMetadata.getComment());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.dropTable(table.remoteTableName());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.setTableComment(table, comment);
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Optional<String> comment) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        MongoColumnHandle column = (MongoColumnHandle)columnHandle;
        this.mongoSession.setColumnComment(table, column.baseName(), comment);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (newTableName.toString().getBytes(StandardCharsets.UTF_8).length > 120) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Qualified identifier name must be shorter than or equal to '%s' bytes: '%s'", 120, newTableName));
        }
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.renameTable(table, newTableName);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column, ColumnPosition position) {
        ColumnPosition columnPosition = position;
        Objects.requireNonNull(columnPosition);
        ColumnPosition columnPosition2 = columnPosition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with FIRST clause");
            }
            case 1: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with AFTER clause");
            }
            case 2: 
        }
        this.mongoSession.addColumn((MongoTableHandle)tableHandle, column);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        this.mongoSession.renameColumn((MongoTableHandle)tableHandle, ((MongoColumnHandle)source).baseName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        this.mongoSession.dropColumn((MongoTableHandle)tableHandle, ((MongoColumnHandle)column).baseName());
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Type type) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        MongoColumnHandle column = (MongoColumnHandle)columnHandle;
        if (!MongoMetadata.canChangeColumnType(column.type(), type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot change type from %s to %s".formatted(column.type(), type));
        }
        this.mongoSession.setColumnType(table, column.baseName(), type);
    }

    private static boolean canChangeColumnType(Type sourceType, Type newType) {
        if (sourceType.equals((Object)newType)) {
            return true;
        }
        if (sourceType == TinyintType.TINYINT) {
            return newType == SmallintType.SMALLINT || newType == IntegerType.INTEGER || newType == BigintType.BIGINT;
        }
        if (sourceType == SmallintType.SMALLINT) {
            return newType == IntegerType.INTEGER || newType == BigintType.BIGINT;
        }
        if (sourceType == IntegerType.INTEGER) {
            return newType == BigintType.BIGINT;
        }
        if (sourceType == RealType.REAL) {
            return newType == DoubleType.DOUBLE;
        }
        if (sourceType instanceof VarcharType || sourceType instanceof CharType) {
            return newType instanceof VarcharType || newType instanceof CharType;
        }
        if (sourceType instanceof DecimalType) {
            DecimalType sourceDecimal = (DecimalType)sourceType;
            if (newType instanceof DecimalType) {
                DecimalType newDecimal = (DecimalType)newType;
                return sourceDecimal.getScale() == newDecimal.getScale() && sourceDecimal.getPrecision() <= newDecimal.getPrecision();
            }
        }
        if (sourceType instanceof ArrayType) {
            ArrayType sourceArrayType = (ArrayType)sourceType;
            if (newType instanceof ArrayType) {
                ArrayType newArrayType = (ArrayType)newType;
                return MongoMetadata.canChangeColumnType(sourceArrayType.getElementType(), newArrayType.getElementType());
            }
        }
        if (sourceType instanceof RowType) {
            RowType sourceRowType = (RowType)sourceType;
            if (newType instanceof RowType) {
                RowType newRowType = (RowType)newType;
                List fields = (List)Streams.concat((Stream[])new Stream[]{sourceRowType.getFields().stream(), newRowType.getFields().stream()}).distinct().collect(ImmutableList.toImmutableList());
                for (RowType.Field field : fields) {
                    String fieldName = (String)field.getName().orElseThrow();
                    if (!MongoMetadata.fieldExists(sourceRowType, fieldName) || !MongoMetadata.fieldExists(newRowType, fieldName) || MongoMetadata.canChangeColumnType(MongoMetadata.findFieldByName(sourceRowType.getFields(), fieldName).getType(), MongoMetadata.findFieldByName(newRowType.getFields(), fieldName).getType())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static RowType.Field findFieldByName(List<RowType.Field> fields, String fieldName) {
        return (RowType.Field)fields.stream().filter(field -> ((String)field.getName().orElseThrow()).equals(fieldName)).collect(MoreCollectors.onlyElement());
    }

    private static boolean fieldExists(RowType structType, String fieldName) {
        for (RowType.Field field : structType.getFields()) {
            if (!((String)field.getName().orElseThrow()).equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        if (replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        RemoteTableName remoteTableName = this.mongoSession.toRemoteSchemaTableName(tableMetadata.getTable());
        List<MongoColumnHandle> columns = MongoMetadata.buildColumnHandles(tableMetadata);
        this.mongoSession.createTable(remoteTableName, columns, tableMetadata.getComment());
        List handleColumns = (List)columns.stream().filter(column -> !column.hidden()).collect(ImmutableList.toImmutableList());
        Closer closer = Closer.create();
        closer.register(() -> this.mongoSession.dropTable(remoteTableName));
        this.setRollback(() -> {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        });
        if (retryMode == RetryMode.NO_RETRIES) {
            return new MongoOutputTableHandle(remoteTableName, handleColumns, Optional.empty(), Optional.empty());
        }
        MongoColumnHandle pageSinkIdColumn = MongoMetadata.buildPageSinkIdColumn((Set)columns.stream().map(MongoColumnHandle::baseName).collect(ImmutableSet.toImmutableSet()));
        ImmutableList allTemporaryTableColumns = ImmutableList.builderWithExpectedSize((int)(columns.size() + 1)).addAll(columns).add((Object)pageSinkIdColumn).build();
        RemoteTableName temporaryTable = new RemoteTableName(remoteTableName.databaseName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        this.mongoSession.createTable(temporaryTable, (List<MongoColumnHandle>)allTemporaryTableColumns, Optional.empty());
        closer.register(() -> this.mongoSession.dropTable(temporaryTable));
        return new MongoOutputTableHandle(remoteTableName, handleColumns, Optional.of(temporaryTable.collectionName()), Optional.of(pageSinkIdColumn.baseName()));
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        MongoOutputTableHandle handle = (MongoOutputTableHandle)tableHandle;
        if (handle.temporaryTableName().isPresent()) {
            this.finishInsert(session, handle.remoteTableName(), handle.getTemporaryRemoteTableName().get(), handle.pageSinkIdColumnName().get(), fragments);
        }
        this.clearRollback();
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> insertedColumns, RetryMode retryMode) {
        MongoTable table = this.mongoSession.getTable(((MongoTableHandle)tableHandle).schemaTableName());
        MongoTableHandle handle = table.tableHandle();
        List<MongoColumnHandle> columns = table.columns();
        List handleColumns = (List)columns.stream().filter(column -> !column.hidden()).peek(column -> MongoMetadata.validateColumnNameForInsert(column.baseName())).collect(ImmutableList.toImmutableList());
        if (retryMode == RetryMode.NO_RETRIES) {
            return new MongoInsertTableHandle(handle.remoteTableName(), handleColumns, Optional.empty(), Optional.empty());
        }
        MongoColumnHandle pageSinkIdColumn = MongoMetadata.buildPageSinkIdColumn((Set)columns.stream().map(MongoColumnHandle::baseName).collect(ImmutableSet.toImmutableSet()));
        ImmutableList allColumns = ImmutableList.builderWithExpectedSize((int)(columns.size() + 1)).addAll(columns).add((Object)pageSinkIdColumn).build();
        RemoteTableName temporaryTable = new RemoteTableName(handle.schemaTableName().getSchemaName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        this.mongoSession.createTable(temporaryTable, (List<MongoColumnHandle>)allColumns, Optional.empty());
        this.setRollback(() -> this.mongoSession.dropTable(temporaryTable));
        return new MongoInsertTableHandle(handle.remoteTableName(), handleColumns, Optional.of(temporaryTable.collectionName()), Optional.of(pageSinkIdColumn.baseName()));
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        MongoInsertTableHandle handle = (MongoInsertTableHandle)insertHandle;
        if (handle.temporaryTableName().isPresent()) {
            this.finishInsert(session, handle.remoteTableName(), handle.getTemporaryRemoteTableName().get(), handle.pageSinkIdColumnName().get(), fragments);
        }
        this.clearRollback();
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInsert(ConnectorSession session, RemoteTableName targetTable, RemoteTableName temporaryTable, String pageSinkIdColumnName, Collection<Slice> fragments) {
        Closer closer = Closer.create();
        closer.register(() -> this.mongoSession.dropTable(temporaryTable));
        try {
            RemoteTableName pageSinkIdsTable = new RemoteTableName(temporaryTable.databaseName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
            MongoColumnHandle pageSinkIdColumn = new MongoColumnHandle(pageSinkIdColumnName, (List<String>)ImmutableList.of(), TRINO_PAGE_SINK_ID_COLUMN_TYPE, false, false, Optional.empty());
            this.mongoSession.createTable(pageSinkIdsTable, (List<MongoColumnHandle>)ImmutableList.of((Object)pageSinkIdColumn), Optional.empty());
            closer.register(() -> this.mongoSession.dropTable(pageSinkIdsTable));
            MongoCollection<Document> pageSinkIdsCollection = this.mongoSession.getCollection(pageSinkIdsTable);
            List pageSinkIds = (List)fragments.stream().map(slice -> new Document(pageSinkIdColumnName, (Object)slice.getLong(0))).collect(ImmutableList.toImmutableList());
            pageSinkIdsCollection.insertMany(pageSinkIds);
            MongoCollection<Document> temporaryCollection = this.mongoSession.getCollection(temporaryTable);
            temporaryCollection.aggregate((List)ImmutableList.of((Object)Aggregates.lookup((String)pageSinkIdsTable.collectionName(), (String)pageSinkIdColumnName, (String)pageSinkIdColumnName, (String)"page_sink_id"), (Object)Aggregates.match((Bson)Filters.ne((String)"page_sink_id", (Object)ImmutableList.of())), (Object)Aggregates.project((Bson)Projections.exclude((String[])new String[]{"page_sink_id"})), (Object)Aggregates.merge((String)targetTable.collectionName()))).toCollection();
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        }
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new MongoColumnHandle("$merge_row_id", (List<String>)ImmutableList.of(), (Type)BigintType.BIGINT, true, false, Optional.empty());
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        MongoTableHandle table = (MongoTableHandle)handle;
        return OptionalLong.of(this.mongoSession.deleteDocuments(table.remoteTableName(), table.constraint()));
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        MongoTableHandle tableHandle = (MongoTableHandle)table;
        ImmutableList.Builder localProperties = ImmutableList.builder();
        MongoTable tableInfo = this.mongoSession.getTable(tableHandle.schemaTableName());
        Map<String, ColumnHandle> columns = this.getColumnHandles(session, tableHandle);
        for (MongoIndex index : tableInfo.indexes()) {
            for (MongoIndex.MongodbIndexKey key : index.keys()) {
                if (key.sortOrder().isEmpty() || columns.get(key.name()) == null) continue;
                localProperties.add((Object)new SortingProperty((Object)columns.get(key.name()), key.sortOrder().get()));
            }
        }
        return new ConnectorTableProperties(TupleDomain.all(), Optional.empty(), Optional.empty(), (List)localProperties.build());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        MongoTableHandle handle = (MongoTableHandle)table;
        if (limit == 0L) {
            return Optional.empty();
        }
        if (limit > Integer.MAX_VALUE) {
            return Optional.empty();
        }
        if (handle.limit().isPresent() && (long)handle.limit().getAsInt() <= limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)new MongoTableHandle(handle.schemaTableName(), handle.remoteTableName(), handle.filter(), handle.constraint(), handle.projectedColumns(), OptionalInt.of(Math.toIntExact(limit))), true, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        MongoTableHandle handle = (MongoTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.constraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<ColumnHandle, Domain> supported = new HashMap<ColumnHandle, Domain>();
            HashMap<MongoColumnHandle, Domain> unsupported = new HashMap<MongoColumnHandle, Domain>();
            for (Map.Entry entry : domains.entrySet()) {
                MongoColumnHandle columnHandle = (MongoColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                Type columnType = columnHandle.type();
                if (TypeUtils.isPushdownSupportedType(columnType)) {
                    supported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                unsupported.put(columnHandle, domain);
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new MongoTableHandle(handle.schemaTableName(), handle.remoteTableName(), handle.filter(), (TupleDomain<ColumnHandle>)newDomain, handle.projectedColumns(), handle.limit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter, constraint.getExpression(), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!MongoSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression, MongoMetadata::isSupportedForPushdown).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ApplyProjectionUtil::createProjectedColumnRepresentation));
        MongoTableHandle mongoTableHandle = (MongoTableHandle)handle;
        if (columnProjections.values().stream().allMatch(ApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            Set projectedColumns = (Set)assignments.values().stream().map(MongoColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
            if (mongoTableHandle.projectedColumns().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((MongoColumnHandle)assignment.getValue()).type())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)mongoTableHandle.withProjectedColumns(projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            ApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (ApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            MongoColumnHandle baseColumnHandle = (MongoColumnHandle)assignments.get(projectedColumn.getVariable().getName());
            MongoColumnHandle projectedColumnHandle = MongoMetadata.projectColumn(baseColumnHandle, projectedColumn.getDereferenceIndices(), expression2.getType());
            String projectedColumnName = projectedColumnHandle.getQualifiedName();
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, (ColumnHandle)projectedColumnHandle, expression2.getType());
            newAssignments.putIfAbsent(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> MongoMetadata.lambda$applyProjection$2((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        List outputAssignments = (List)newAssignments.values().stream().collect(ImmutableList.toImmutableList());
        return Optional.of(new ProjectionApplicationResult((Object)mongoTableHandle.withProjectedColumns((Set<MongoColumnHandle>)projectedColumnsBuilder.build()), newProjections, outputAssignments, false));
    }

    private static boolean isSupportedForPushdown(ConnectorExpression connectorExpression) {
        if (connectorExpression instanceof Variable) {
            return true;
        }
        if (connectorExpression instanceof FieldDereference) {
            FieldDereference fieldDereference = (FieldDereference)connectorExpression;
            RowType rowType = (RowType)fieldDereference.getTarget().getType();
            if (MongoMetadata.isDBRefField((Type)rowType)) {
                return false;
            }
            RowType.Field field = (RowType.Field)rowType.getFields().get(fieldDereference.getField());
            if (field.getName().isEmpty()) {
                return false;
            }
            String fieldName = (String)field.getName().get();
            return !fieldName.contains(".") && !fieldName.contains("$");
        }
        return false;
    }

    private static MongoColumnHandle projectColumn(MongoColumnHandle baseColumn, List<Integer> indices, Type projectedColumnType) {
        if (indices.isEmpty()) {
            return baseColumn;
        }
        ImmutableList.Builder dereferenceNamesBuilder = ImmutableList.builder();
        dereferenceNamesBuilder.addAll(baseColumn.dereferenceNames());
        Type type = baseColumn.type();
        RowType parentType = null;
        for (int index : indices) {
            Preconditions.checkArgument((boolean)(type instanceof RowType), (Object)"type should be Row type");
            RowType rowType = (RowType)type;
            RowType.Field field = (RowType.Field)rowType.getFields().get(index);
            dereferenceNamesBuilder.add((Object)((String)field.getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ROW type does not have field names declared: " + String.valueOf(rowType)))));
            parentType = rowType;
            type = field.getType();
        }
        return new MongoColumnHandle(baseColumn.baseName(), (List<String>)dereferenceNamesBuilder.build(), projectedColumnType, baseColumn.hidden(), MongoMetadata.isDBRefField(parentType), baseColumn.comment());
    }

    private static boolean isDBRefField(Type type) {
        if (!(type instanceof RowType)) {
            return false;
        }
        RowType rowType = (RowType)type;
        Objects.requireNonNull(type, "type is null");
        List fields = rowType.getFields();
        if (fields.size() != 3) {
            return false;
        }
        return ((String)((RowType.Field)fields.get(0)).getName().orElseThrow()).equals("databaseName") && ((RowType.Field)fields.get(0)).getType().equals((Object)VarcharType.VARCHAR) && ((String)((RowType.Field)fields.get(1)).getName().orElseThrow()).equals("collectionName") && ((RowType.Field)fields.get(1)).getType().equals((Object)VarcharType.VARCHAR) && ((String)((RowType.Field)fields.get(2)).getName().orElseThrow()).equals("id");
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof Query.QueryFunctionHandle)) {
            return Optional.empty();
        }
        Query.QueryFunctionHandle queryFunctionHandle = (Query.QueryFunctionHandle)handle;
        ConnectorTableHandle tableHandle = queryFunctionHandle.getTableHandle();
        List columnHandles = (List)this.getColumnHandles(session, tableHandle).values().stream().filter(column -> !((MongoColumnHandle)column).hidden()).collect(ImmutableList.toImmutableList());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, columnHandles));
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return ((MongoTableHandle)tableHandle).schemaTableName();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        MongoTable mongoTable = this.mongoSession.getTable(tableName);
        List columns = (List)mongoTable.columns().stream().map(MongoColumnHandle::toColumnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(tableName, columns, (Map)ImmutableMap.of(), mongoTable.comment());
    }

    private static List<MongoColumnHandle> buildColumnHandles(ConnectorTableMetadata tableMetadata) {
        return tableMetadata.getColumns().stream().map(m -> new MongoColumnHandle(m.getName(), (List<String>)ImmutableList.of(), m.getType(), m.isHidden(), false, Optional.ofNullable(m.getComment()))).collect(Collectors.toList());
    }

    private static void validateColumnNameForInsert(String columnName) {
        if (columnName.contains("$") || columnName.contains(".")) {
            throw new IllegalArgumentException("Column name must not contain '$' or '.' for INSERT: " + columnName);
        }
    }

    private static MongoColumnHandle buildPageSinkIdColumn(Set<String> otherColumnNames) {
        String baseColumnName = "trino_page_sink_id";
        Object columnName = baseColumnName;
        int suffix = 1;
        while (otherColumnNames.contains(columnName)) {
            columnName = baseColumnName + "_" + suffix;
            ++suffix;
        }
        return new MongoColumnHandle((String)columnName, (List<String>)ImmutableList.of(), TRINO_PAGE_SINK_ID_COLUMN_TYPE, false, false, Optional.empty());
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$2(Map newVariables, ConnectorExpression expression) {
        return ApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }
}

