/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertManyOptions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.plugin.mongodb.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bson.BsonInvalidOperationException;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class MongoPageSink
implements ConnectorPageSink {
    private final MongoSession mongoSession;
    private final RemoteTableName remoteTableName;
    private final List<MongoColumnHandle> columns;
    private final String implicitPrefix;
    private final Optional<String> pageSinkIdColumnName;
    private final ConnectorPageSinkId pageSinkId;

    public MongoPageSink(MongoSession mongoSession, RemoteTableName remoteTableName, List<MongoColumnHandle> columns, String implicitPrefix, Optional<String> pageSinkIdColumnName, ConnectorPageSinkId pageSinkId) {
        this.mongoSession = Objects.requireNonNull(mongoSession, "mongoSession is null");
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.implicitPrefix = Objects.requireNonNull(implicitPrefix, "implicitPrefix is null");
        this.pageSinkIdColumnName = Objects.requireNonNull(pageSinkIdColumnName, "pageSinkIdColumnName is null");
        this.pageSinkId = Objects.requireNonNull(pageSinkId, "pageSinkId is null");
    }

    public CompletableFuture<?> appendPage(Page page) {
        MongoCollection<Document> collection = this.mongoSession.getCollection(this.remoteTableName);
        ArrayList<Document> batch = new ArrayList<Document>(page.getPositionCount());
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Document doc = new Document();
            this.pageSinkIdColumnName.ifPresent(columnName -> doc.append(columnName, (Object)this.pageSinkId.getId()));
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                MongoColumnHandle column = this.columns.get(channel);
                doc.append(column.baseName(), this.getObjectValue(this.columns.get(channel).type(), page.getBlock(channel), position));
            }
            batch.add(doc);
        }
        collection.insertMany(batch, new InsertManyOptions().ordered(true));
        return NOT_BLOCKED;
    }

    private Object getObjectValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
                return new ObjectId();
            }
            return null;
        }
        if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            return new ObjectId(ObjectIdType.OBJECT_ID.getSlice(block, position).getBytes());
        }
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return BooleanType.BOOLEAN.getBoolean(block, position);
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return BigintType.BIGINT.getLong(block, position);
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return IntegerType.INTEGER.getInt(block, position);
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return SmallintType.SMALLINT.getShort(block, position);
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return TinyintType.TINYINT.getByte(block, position);
        }
        if (type.equals((Object)RealType.REAL)) {
            return Float.valueOf(RealType.REAL.getFloat(block, position));
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return DoubleType.DOUBLE.getDouble(block, position);
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return varcharType.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType).toStringUtf8();
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return new Binary(VarbinaryType.VARBINARY.getSlice(block, position).getBytes());
        }
        if (type.equals((Object)DateType.DATE)) {
            int days = DateType.DATE.getInt(block, position);
            return LocalDate.ofEpochDay(days);
        }
        if (type.equals((Object)TimeType.TIME_MILLIS)) {
            long picos = TimeType.TIME_MILLIS.getLong(block, position);
            return LocalTime.ofNanoOfDay(Timestamps.roundDiv((long)picos, (long)1000L));
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
            long millisUtc = Math.floorDiv(TimestampType.TIMESTAMP_MILLIS.getLong(block, position), 1000);
            Instant instant = Instant.ofEpochMilli(millisUtc);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong(block, position));
            Instant instant = Instant.ofEpochMilli(millisUtc);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return Decimals.readBigDecimal((DecimalType)decimalType, (Block)block, (int)position);
        }
        if (TypeUtils.isJsonType(type)) {
            String json = type.getSlice(block, position).toStringUtf8();
            try {
                return Document.parse((String)json);
            }
            catch (BsonInvalidOperationException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't convert json to MongoDB Document: " + json, (Throwable)e);
            }
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            Block arrayBlock = arrayType.getObject(block, position);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = this.getObjectValue(elementType, arrayBlock, i);
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            SqlMap sqlMap = mapType.getObject(block, position);
            int size = sqlMap.getSize();
            int rawOffset = sqlMap.getRawOffset();
            Block rawKeyBlock = sqlMap.getRawKeyBlock();
            Block rawValueBlock = sqlMap.getRawValueBlock();
            ArrayList values = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                HashMap<String, Object> mapValue = new HashMap<String, Object>();
                mapValue.put("key", this.getObjectValue(keyType, rawKeyBlock, rawOffset + i));
                mapValue.put("value", this.getObjectValue(valueType, rawValueBlock, rawOffset + i));
                values.add(mapValue);
            }
            return Collections.unmodifiableList(values);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            SqlRow sqlRow = rowType.getObject(block, position);
            int rawIndex = sqlRow.getRawIndex();
            List fieldTypes = rowType.getTypeParameters();
            if (fieldTypes.size() != sqlRow.getFieldCount()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count");
            }
            if (this.isImplicitRowType((Type)rowType)) {
                ArrayList<Object> rowValue = new ArrayList<Object>();
                for (int i = 0; i < sqlRow.getFieldCount(); ++i) {
                    Object element = this.getObjectValue((Type)fieldTypes.get(i), sqlRow.getRawFieldBlock(i), rawIndex);
                    rowValue.add(element);
                }
                return Collections.unmodifiableList(rowValue);
            }
            HashMap<String, Object> rowValue = new HashMap<String, Object>();
            for (int i = 0; i < sqlRow.getFieldCount(); ++i) {
                rowValue.put((String)((Object)((TypeSignatureParameter)rowType.getTypeSignature().getParameters().get(i)).getNamedTypeSignature().getName().orElse("field" + i)), this.getObjectValue((Type)fieldTypes.get(i), sqlRow.getRawFieldBlock(i), rawIndex));
            }
            return Collections.unmodifiableMap(rowValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + String.valueOf(type));
    }

    private boolean isImplicitRowType(Type type) {
        return type.getTypeSignature().getParameters().stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).filter(Optional::isPresent).map(Optional::get).allMatch(name -> name.startsWith(this.implicitPrefix));
    }

    public CompletableFuture<Collection<Slice>> finish() {
        Slice value = Slices.allocate((int)8);
        value.setLong(0, this.pageSinkId.getId());
        return CompletableFuture.completedFuture(ImmutableList.of((Object)value));
    }

    public void abort() {
    }
}

