/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import com.mongodb.DBRef;
import com.mongodb.client.MongoCursor;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoErrorCode;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.plugin.mongodb.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.joda.time.chrono.ISOChronology;

public class MongoPageSource
implements ConnectorPageSource {
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();
    private static final int ROWS_PER_REQUEST = 1024;
    private final MongoCursor<Document> cursor;
    private final List<MongoColumnHandle> columns;
    private final List<Type> columnTypes;
    private Document currentDoc;
    private boolean finished;
    private final PageBuilder pageBuilder;

    public MongoPageSource(MongoSession mongoSession, MongoTableHandle tableHandle, List<MongoColumnHandle> columns) {
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.columnTypes = columns.stream().map(MongoColumnHandle::type).collect(Collectors.toList());
        this.cursor = mongoSession.execute(tableHandle, columns);
        this.currentDoc = null;
        this.pageBuilder = new PageBuilder(this.columnTypes);
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public SourcePage getNextSourcePage() {
        Verify.verify((boolean)this.pageBuilder.isEmpty());
        for (int i = 0; i < 1024; ++i) {
            if (!this.cursor.hasNext()) {
                this.finished = true;
                break;
            }
            this.currentDoc = (Document)this.cursor.next();
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                MongoColumnHandle columnHandle = this.columns.get(column);
                this.appendTo(this.columnTypes.get(column), MongoPageSource.getColumnValue(this.currentDoc, columnHandle), output);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return SourcePage.create((Page)page);
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block23: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block23;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals((Object)BigintType.BIGINT)) {
                        type.writeLong(output, ((Number)value).longValue());
                        break block23;
                    }
                    if (type.equals((Object)IntegerType.INTEGER)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block23;
                    }
                    if (type.equals((Object)SmallintType.SMALLINT)) {
                        type.writeLong(output, (long)Shorts.checkedCast((long)((Number)value).longValue()));
                        break block23;
                    }
                    if (type.equals((Object)TinyintType.TINYINT)) {
                        type.writeLong(output, (long)SignedBytes.checkedCast((long)((Number)value).longValue()));
                        break block23;
                    }
                    if (type.equals((Object)RealType.REAL)) {
                        type.writeLong(output, (long)Float.floatToIntBits((float)((Number)value).doubleValue()));
                        break block23;
                    }
                    if (type instanceof DecimalType) {
                        DecimalType decimalType = (DecimalType)type;
                        Decimal128 decimal = (Decimal128)value;
                        if (decimal.compareTo(Decimal128.NEGATIVE_ZERO) == 0) {
                            type.writeLong(output, Decimals.encodeShortScaledValue((BigDecimal)BigDecimal.ZERO, (int)decimalType.getScale()));
                        } else {
                            type.writeLong(output, Decimals.encodeShortScaledValue((BigDecimal)decimal.bigDecimalValue(), (int)decimalType.getScale()));
                        }
                        break block23;
                    }
                    if (type.equals((Object)DateType.DATE)) {
                        long utcMillis = ((Date)value).getTime();
                        type.writeLong(output, TimeUnit.MILLISECONDS.toDays(utcMillis));
                        break block23;
                    }
                    if (type.equals((Object)TimeType.TIME_MILLIS)) {
                        long millis = UTC_CHRONOLOGY.millisOfDay().get(((Date)value).getTime());
                        type.writeLong(output, Math.multiplyExact(millis, 1000000000));
                        break block23;
                    }
                    if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
                        type.writeLong(output, ((Date)value).getTime() * 1000L);
                        break block23;
                    }
                    if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
                        type.writeLong(output, DateTimeEncoding.packDateTimeWithZone((long)((Date)value).getTime(), (TimeZoneKey)TimeZoneKey.UTC_KEY));
                        break block23;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + String.valueOf(type.getTypeSignature()));
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block23;
                }
                if (javaType == Int128.class) {
                    DecimalType decimalType = (DecimalType)type;
                    Verify.verify((!decimalType.isShort() ? 1 : 0) != 0, (String)"The type should be long decimal", (Object[])new Object[0]);
                    Decimal128 decimal = (Decimal128)value;
                    if (decimal.compareTo(Decimal128.NEGATIVE_ZERO) == 0) {
                        type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)BigDecimal.ZERO, (int)decimalType.getScale()));
                    } else {
                        BigDecimal result = decimal.bigDecimalValue();
                        type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)result, (int)decimalType.getScale()));
                    }
                    break block23;
                }
                if (javaType == Slice.class) {
                    this.writeSlice(output, type, value);
                    break block23;
                }
                if (javaType == Block.class || javaType == SqlMap.class || javaType == SqlRow.class) {
                    this.writeBlock(output, type, value);
                    break block23;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + String.valueOf(type.getTypeSignature()));
            }
            catch (ClassCastException ignore) {
                output.appendNull();
            }
        }
    }

    private String toVarcharValue(Object value) {
        if (value instanceof Collection) {
            return "[" + String.join((CharSequence)", ", ((Collection)value).stream().map(this::toVarcharValue).collect(Collectors.toList())) + "]";
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.toJson();
        }
        return String.valueOf(value);
    }

    private void writeSlice(BlockBuilder output, Type type, Object value) {
        if (type instanceof VarcharType) {
            type.writeSlice(output, Slices.utf8Slice((String)this.toVarcharValue(value)));
        } else if (type instanceof CharType) {
            CharType charType = (CharType)type;
            type.writeSlice(output, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)value)), (CharType)charType));
        } else if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            type.writeSlice(output, Slices.wrappedBuffer((byte[])((ObjectId)value).toByteArray()));
        } else if (type instanceof VarbinaryType) {
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                type.writeSlice(output, Slices.wrappedBuffer((byte[])binary.getData()));
            } else {
                output.appendNull();
            }
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)((Decimal128)value).bigDecimalValue(), (int)decimalType.getScale()));
        } else if (TypeUtils.isJsonType(type)) {
            type.writeSlice(output, JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)this.toVarcharValue(value))));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + String.valueOf(type.getTypeSignature()));
        }
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (value instanceof List) {
                List list = (List)value;
                ((ArrayBlockBuilder)output).buildEntry(elementBuilder -> list.forEach(element -> this.appendTo(arrayType.getElementType(), element, elementBuilder)));
                return;
            }
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            if (value instanceof List) {
                ((MapBlockBuilder)output).buildEntry((keyBuilder, valueBuilder) -> {
                    for (Object element : (List)value) {
                        Map document;
                        if (!(element instanceof Map) || !(document = (Map)element).containsKey("key") || !document.containsKey("value")) continue;
                        this.appendTo(mapType.getKeyType(), document.get("key"), keyBuilder);
                        this.appendTo(mapType.getValueType(), document.get("value"), valueBuilder);
                    }
                });
                return;
            }
            if (value instanceof Map) {
                Map document = (Map)value;
                ((MapBlockBuilder)output).buildEntry((keyBuilder, valueBuilder) -> {
                    for (Map.Entry entry : document.entrySet()) {
                        this.appendTo(mapType.getKeyType(), entry.getKey(), keyBuilder);
                        this.appendTo(mapType.getValueType(), entry.getValue(), valueBuilder);
                    }
                });
                return;
            }
        } else if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List fields = rowType.getFields();
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
                    for (int i = 0; i < fields.size(); ++i) {
                        RowType.Field field = (RowType.Field)fields.get(i);
                        String fieldName = (String)((Object)field.getName().orElse("field" + i));
                        this.appendTo(field.getType(), mapValue.get(fieldName), (BlockBuilder)fieldBuilders.get(i));
                    }
                });
                return;
            }
            if (value instanceof DBRef) {
                DBRef dbRefValue = (DBRef)value;
                if (fields.size() != 3) {
                    throw new TrinoException((ErrorCodeSupplier)MongoErrorCode.MONGODB_INVALID_TYPE, "DBRef should have 3 fields : " + String.valueOf(type));
                }
                ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
                    block10: for (int i = 0; i < fields.size(); ++i) {
                        RowType.Field field = (RowType.Field)fields.get(i);
                        Type fieldType = field.getType();
                        String fieldName = (String)field.getName().orElseThrow();
                        BlockBuilder builder = (BlockBuilder)fieldBuilders.get(i);
                        switch (fieldName) {
                            case "databaseName": {
                                this.appendTo(fieldType, dbRefValue.getDatabaseName(), builder);
                                continue block10;
                            }
                            case "collectionName": {
                                this.appendTo(fieldType, dbRefValue.getCollectionName(), builder);
                                continue block10;
                            }
                            case "id": {
                                this.appendTo(fieldType, dbRefValue.getId(), builder);
                                continue block10;
                            }
                            default: {
                                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected field name for DBRef: " + fieldName);
                            }
                        }
                    }
                });
                return;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
                    for (int index = 0; index < fields.size(); ++index) {
                        if (index < listValue.size()) {
                            this.appendTo(((RowType.Field)fields.get(index)).getType(), listValue.get(index), (BlockBuilder)fieldBuilders.get(index));
                            continue;
                        }
                        ((BlockBuilder)fieldBuilders.get(index)).appendNull();
                    }
                });
                return;
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Block: " + String.valueOf(type.getTypeSignature()));
        }
        output.appendNull();
    }

    private static Object getColumnValue(Document document, MongoColumnHandle mongoColumnHandle) {
        Object value = document.get((Object)mongoColumnHandle.baseName());
        if (mongoColumnHandle.isBaseColumn()) {
            return value;
        }
        if (value instanceof DBRef) {
            DBRef dbRefValue = (DBRef)value;
            return MongoPageSource.getDbRefValue(dbRefValue, mongoColumnHandle);
        }
        Document documentValue = (Document)value;
        for (String dereferenceName : mongoColumnHandle.dereferenceNames()) {
            if (documentValue == null) {
                return null;
            }
            value = documentValue.get((Object)dereferenceName);
            if (value instanceof Document) {
                Document nestedDocument;
                documentValue = nestedDocument = (Document)value;
                continue;
            }
            if (!(value instanceof DBRef)) continue;
            DBRef dbRefValue = (DBRef)value;
            return MongoPageSource.getDbRefValue(dbRefValue, mongoColumnHandle);
        }
        return value;
    }

    private static Object getDbRefValue(DBRef dbRefValue, MongoColumnHandle columnHandle) {
        String leafColumnName;
        if (columnHandle.type() instanceof RowType) {
            return dbRefValue;
        }
        Preconditions.checkArgument((boolean)columnHandle.dbRefField(), (String)"columnHandle is not a dbRef field: %s", (Object)columnHandle);
        List<String> dereferenceNames = columnHandle.dereferenceNames();
        Preconditions.checkState((!dereferenceNames.isEmpty() ? 1 : 0) != 0, (Object)"dereferenceNames is empty");
        return switch (leafColumnName = dereferenceNames.getLast()) {
            case "databaseName" -> dbRefValue.getDatabaseName();
            case "collectionName" -> dbRefValue.getCollectionName();
            case "id" -> dbRefValue.getId();
            default -> throw new IllegalStateException("Unsupported DBRef column name: " + leafColumnName);
        };
    }

    public void close() {
        this.cursor.close();
    }
}

