/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.plugin.mongodb.MongoMetadata;
import io.trino.plugin.mongodb.MongoMetadataFactory;
import io.trino.plugin.mongodb.MongoTransactionHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MongoTransactionManager {
    private final ConcurrentMap<ConnectorTransactionHandle, MongoMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MongoMetadata>();
    private final MongoMetadataFactory metadataFactory;

    @Inject
    public MongoTransactionManager(MongoMetadataFactory metadataFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        MongoTransactionHandle transaction = new MongoTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create());
        return transaction;
    }

    public MongoMetadata getMetadata(ConnectorTransactionHandle transaction) {
        MongoMetadata metadata = (MongoMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MongoMetadata metadata = (MongoMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        metadata.rollback();
    }
}

