/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import java.util.Collection;

public abstract class DbClientSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";

    public static <REQUEST> SpanNameExtractor<REQUEST> create(DbClientAttributesGetter<REQUEST, ?> getter) {
        return new GenericDbClientSpanNameExtractor(getter);
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(SqlClientAttributesGetter<REQUEST, ?> getter) {
        return new SqlClientSpanNameExtractor(getter);
    }

    private DbClientSpanNameExtractor() {
    }

    protected String computeSpanName(String dbName, String operation, String mainIdentifier) {
        if (operation == null) {
            return dbName == null ? DEFAULT_SPAN_NAME : dbName;
        }
        StringBuilder name = new StringBuilder(operation);
        if (dbName != null || mainIdentifier != null) {
            name.append(' ');
        }
        if (dbName != null && (mainIdentifier == null || mainIdentifier.indexOf(46) == -1)) {
            name.append(dbName);
            if (mainIdentifier != null) {
                name.append('.');
            }
        }
        if (mainIdentifier != null) {
            name.append(mainIdentifier);
        }
        return name.toString();
    }

    private static final class GenericDbClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final DbClientAttributesGetter<REQUEST, ?> getter;

        private GenericDbClientSpanNameExtractor(DbClientAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        public String extract(REQUEST request) {
            String namespace = this.getter.getDbNamespace(request);
            String operationName = this.getter.getDbOperationName(request);
            return this.computeSpanName(namespace, operationName, null);
        }
    }

    private static final class SqlClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final SqlClientAttributesGetter<REQUEST, ?> getter;

        private SqlClientSpanNameExtractor(SqlClientAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        public String extract(REQUEST request) {
            String namespace = this.getter.getDbNamespace(request);
            Collection<String> rawQueryTexts = this.getter.getRawQueryTexts(request);
            if (rawQueryTexts.isEmpty()) {
                return this.computeSpanName(namespace, null, null);
            }
            if (!SemconvStability.emitStableDatabaseSemconv()) {
                if (rawQueryTexts.size() > 1) {
                    return this.computeSpanName(namespace, null, null);
                }
                SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryTexts.iterator().next());
                return this.computeSpanName(namespace, sanitizedStatement.getOperation(), sanitizedStatement.getMainIdentifier());
            }
            if (rawQueryTexts.size() == 1) {
                SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryTexts.iterator().next());
                String operation = sanitizedStatement.getOperation();
                if (this.isBatch(request)) {
                    operation = "BATCH " + operation;
                }
                return this.computeSpanName(namespace, operation, sanitizedStatement.getMainIdentifier());
            }
            MultiQuery multiQuery = MultiQuery.analyze(rawQueryTexts, false);
            return this.computeSpanName(namespace, multiQuery.getOperation() != null ? "BATCH " + multiQuery.getOperation() : "BATCH", multiQuery.getMainIdentifier());
        }

        private boolean isBatch(REQUEST request) {
            Long batchSize = this.getter.getBatchSize(request);
            return batchSize != null && batchSize > 1L;
        }
    }
}

