/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.ListIndexesIterable;
import io.trino.spi.connector.SortOrder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;

public record MongoIndex(List<MongodbIndexKey> keys) {
    public MongoIndex(List<MongodbIndexKey> keys) {
        this.keys = keys = ImmutableList.copyOf(keys);
    }

    public static List<MongoIndex> parse(ListIndexesIterable<Document> indexes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Document index : indexes) {
            Document key = (Document)index.get((Object)"key");
            if (key.containsKey((Object)"_fts")) continue;
            builder.add((Object)new MongoIndex(MongoIndex.parseKey(key)));
        }
        return builder.build();
    }

    private static List<MongodbIndexKey> parseKey(Document key) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : key.keySet()) {
            Object value = key.get((Object)name);
            if (value instanceof Number) {
                Number number = (Number)value;
                int order = number.intValue();
                Preconditions.checkState((order == 1 || order == -1 ? 1 : 0) != 0, (Object)"Unknown index sort order");
                SortOrder sortOrder = order == 1 ? SortOrder.ASC_NULLS_LAST : SortOrder.DESC_NULLS_LAST;
                builder.add((Object)new MongodbIndexKey(name, Optional.of(sortOrder)));
                continue;
            }
            if (value instanceof String) {
                builder.add((Object)new MongodbIndexKey(name, Optional.empty()));
                continue;
            }
            throw new UnsupportedOperationException("Unknown index type: " + value.toString());
        }
        return builder.build();
    }

    public record MongodbIndexKey(String name, Optional<SortOrder> sortOrder) {
        public MongodbIndexKey {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(sortOrder, "sortOrder is null");
        }
    }
}

