/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcIdentity;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.RemoteTableNameCacheKey;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class BaseJdbcClient
implements JdbcClient {
    private static final Logger log = Logger.get(BaseJdbcClient.class);
    @Deprecated
    private static final Map<Type, WriteMapping> WRITE_MAPPINGS = ImmutableMap.builder().put((Object)BooleanType.BOOLEAN, (Object)WriteMapping.booleanMapping("boolean", StandardColumnMappings.booleanWriteFunction())).put((Object)BigintType.BIGINT, (Object)WriteMapping.longMapping("bigint", StandardColumnMappings.bigintWriteFunction())).put((Object)IntegerType.INTEGER, (Object)WriteMapping.longMapping("integer", StandardColumnMappings.integerWriteFunction())).put((Object)SmallintType.SMALLINT, (Object)WriteMapping.longMapping("smallint", StandardColumnMappings.smallintWriteFunction())).put((Object)TinyintType.TINYINT, (Object)WriteMapping.longMapping("tinyint", StandardColumnMappings.tinyintWriteFunction())).put((Object)DoubleType.DOUBLE, (Object)WriteMapping.doubleMapping("double precision", StandardColumnMappings.doubleWriteFunction())).put((Object)RealType.REAL, (Object)WriteMapping.longMapping("real", StandardColumnMappings.realWriteFunction())).put((Object)VarbinaryType.VARBINARY, (Object)WriteMapping.sliceMapping("varbinary", StandardColumnMappings.varbinaryWriteFunction())).put((Object)DateType.DATE, (Object)WriteMapping.longMapping("date", StandardColumnMappings.dateWriteFunction())).build();
    protected final ConnectionFactory connectionFactory;
    protected final String identifierQuote;
    protected final Set<String> jdbcTypesMappedToVarchar;
    protected final boolean caseInsensitiveNameMatching;
    protected final Cache<JdbcIdentity, Map<String, String>> remoteSchemaNames;
    protected final Cache<RemoteTableNameCacheKey, Map<String, String>> remoteTableNames;

    public BaseJdbcClient(BaseJdbcConfig config, String identifierQuote, ConnectionFactory connectionFactory) {
        this(identifierQuote, connectionFactory, config.getJdbcTypesMappedToVarchar(), Objects.requireNonNull(config, "config is null").isCaseInsensitiveNameMatching(), config.getCaseInsensitiveNameMatchingCacheTtl());
    }

    public BaseJdbcClient(String identifierQuote, ConnectionFactory connectionFactory, Set<String> jdbcTypesMappedToVarchar, boolean caseInsensitiveNameMatching, Duration caseInsensitiveNameMatchingCacheTtl) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
        this.jdbcTypesMappedToVarchar = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).addAll((Iterable)Objects.requireNonNull(jdbcTypesMappedToVarchar, "jdbcTypesMappedToVarchar is null")).build();
        Objects.requireNonNull(caseInsensitiveNameMatchingCacheTtl, "caseInsensitiveNameMatchingCacheTtl is null");
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        CacheBuilder remoteNamesCacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(caseInsensitiveNameMatchingCacheTtl.toMillis(), TimeUnit.MILLISECONDS);
        this.remoteSchemaNames = remoteNamesCacheBuilder.build();
        this.remoteTableNames = remoteNamesCacheBuilder.build();
    }

    @Override
    public final Set<String> getSchemaNames(ConnectorSession session) {
        Set set;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                set = (Set)this.listSchemas(connection).stream().map(schemaName -> schemaName.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return set;
    }

    protected Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getSchemas(connection.getCatalog(), null);
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_SCHEM");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        return !schemaName.equalsIgnoreCase("information_schema");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block17: {
                JdbcIdentity identity = JdbcIdentity.from(session);
                Optional<String> remoteSchema = schema.map(schemaName -> this.toRemoteSchemaName(identity, connection, (String)schemaName));
                if (remoteSchema.isPresent() && !this.filterSchema(remoteSchema.get())) {
                    ImmutableList immutableList2 = ImmutableList.of();
                    return immutableList2;
                }
                ResultSet resultSet = this.getTables(connection, remoteSchema, Optional.empty());
                try {
                    ImmutableList.Builder list = ImmutableList.builder();
                    while (resultSet.next()) {
                        String tableSchema = this.getTableSchemaName(resultSet);
                        String tableName = resultSet.getString("TABLE_NAME");
                        if (!this.filterSchema(tableSchema)) continue;
                        list.add((Object)new SchemaTableName(tableSchema, tableName));
                    }
                    immutableList = list.build();
                    if (resultSet == null) break block17;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Optional<JdbcTableHandle> optional;
            block20: {
                ArrayList<JdbcTableHandle> tableHandles;
                ResultSet resultSet;
                block18: {
                    Optional<JdbcTableHandle> optional2;
                    block19: {
                        JdbcIdentity identity = JdbcIdentity.from(session);
                        String remoteSchema = this.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
                        String remoteTable = this.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
                        resultSet = this.getTables(connection, Optional.of(remoteSchema), Optional.of(remoteTable));
                        try {
                            tableHandles = new ArrayList<JdbcTableHandle>();
                            while (resultSet.next()) {
                                tableHandles.add(new JdbcTableHandle(schemaTableName, BaseJdbcClient.getRemoteTable(resultSet)));
                            }
                            if (!tableHandles.isEmpty()) break block18;
                            optional2 = Optional.empty();
                            if (resultSet == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                if (tableHandles.size() > 1) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Multiple tables matched: " + schemaTableName);
                }
                optional = Optional.of((JdbcTableHandle)Iterables.getOnlyElement(tableHandles));
                if (resultSet == null) break block20;
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return tableHandle.getColumns().get();
        }
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        SchemaTableName schemaTableName = tableHandle.getRequiredNamedRelation().getSchemaTableName();
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block18: {
                ResultSet resultSet = this.getColumns(tableHandle, connection.getMetaData());
                try {
                    int allColumns = 0;
                    ArrayList<JdbcColumnHandle> columns = new ArrayList<JdbcColumnHandle>();
                    while (resultSet.next()) {
                        if (!Objects.equals(remoteTableName, BaseJdbcClient.getRemoteTable(resultSet))) continue;
                        ++allColumns;
                        String columnName = resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle((int)BaseJdbcClient.getInteger(resultSet, "DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null")), Optional.ofNullable(resultSet.getString("TYPE_NAME")), BaseJdbcClient.getInteger(resultSet, "COLUMN_SIZE"), BaseJdbcClient.getInteger(resultSet, "DECIMAL_DIGITS"), Optional.empty(), Optional.empty());
                        Optional<ColumnMapping> columnMapping = this.toColumnMapping(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{schemaTableName, columnName, typeHandle, columnMapping});
                        boolean nullable = resultSet.getInt("NULLABLE") != 0;
                        Optional<String> comment = Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
                        if (columnMapping.isPresent()) {
                            columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(columnMapping.get().getType()).setNullable(nullable).setComment(comment).build());
                        }
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling(session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toTrinoType() returned empty for %s", (Object)((Object)unsupportedTypeHandling), (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(schemaTableName, String.format("Table '%s' has no supported columns (all %s columns are not supported)", schemaTableName, allColumns));
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block18;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected static Optional<Integer> getInteger(ResultSet resultSet, String columnLabel) throws SQLException {
        int value = resultSet.getInt(columnLabel);
        if (resultSet.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    protected ResultSet getColumns(JdbcTableHandle tableHandle, DatabaseMetaData metadata) throws SQLException {
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        return metadata.getColumns(remoteTableName.getCatalogName().orElse(null), BaseJdbcClient.escapeNamePattern(remoteTableName.getSchemaName(), metadata.getSearchStringEscape()).orElse(null), BaseJdbcClient.escapeNamePattern(Optional.of(remoteTableName.getTableName()), metadata.getSearchStringEscape()).orElse(null), null);
    }

    @Deprecated
    protected Optional<ColumnMapping> legacyToPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional<ColumnMapping> mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        Optional<ColumnMapping> connectorMapping = StandardColumnMappings.legacyDefaultColumnMapping(typeHandle);
        if (connectorMapping.isPresent()) {
            return connectorMapping;
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling(session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return BaseJdbcClient.mapToUnboundedVarchar(typeHandle);
        }
        return Optional.empty();
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        List list;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                list = (List)typeHandles.stream().map(typeHandle -> this.toColumnMapping(session, connection, (JdbcTypeHandle)typeHandle).orElseThrow(() -> new VerifyException(String.format("Unsupported type handle %s", typeHandle)))).collect(ImmutableList.toImmutableList());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return list;
    }

    protected Optional<ColumnMapping> getForcedMappingToVarchar(JdbcTypeHandle typeHandle) {
        if (typeHandle.getJdbcTypeName().isPresent() && this.jdbcTypesMappedToVarchar.contains(typeHandle.getJdbcTypeName().get())) {
            return BaseJdbcClient.mapToUnboundedVarchar(typeHandle);
        }
        return Optional.empty();
    }

    protected static Optional<ColumnMapping> mapToUnboundedVarchar(JdbcTypeHandle typeHandle) {
        VarcharType unboundedVarcharType = VarcharType.createUnboundedVarcharType();
        return Optional.of(ColumnMapping.sliceMapping((Type)unboundedVarcharType, StandardColumnMappings.varcharReadFunction(unboundedVarcharType), (statement, index, value) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Underlying type that is mapped to VARCHAR is not supported for INSERT: " + typeHandle.getJdbcTypeName().get());
        }, PredicatePushdownController.DISABLE_PUSHDOWN));
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)new JdbcSplit(Optional.empty())));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split) throws SQLException {
        Connection connection = this.connectionFactory.openConnection(session);
        try {
            connection.setReadOnly(true);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, String> columnExpressions) {
        PreparedQuery preparedQuery;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                preparedQuery = this.applyQueryTransformations(table, new QueryBuilder(this).prepareQuery(session, connection, table.getRelationHandle(), groupingSets, columns, columnExpressions, table.getConstraint(), Optional.empty()));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return preparedQuery;
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        for (JdbcJoinCondition joinCondition : joinConditions) {
            if (this.isSupportedJoinCondition(joinCondition)) continue;
            return Optional.empty();
        }
        QueryBuilder queryBuilder = new QueryBuilder(this);
        return Optional.of(queryBuilder.prepareJoinQuery(session, joinType, leftSource, rightSource, joinConditions, leftAssignments, rightAssignments));
    }

    protected boolean isSupportedJoinCondition(JdbcJoinCondition joinCondition) {
        return false;
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        QueryBuilder queryBuilder = new QueryBuilder(this);
        PreparedQuery preparedQuery = this.applyQueryTransformations(table, queryBuilder.prepareQuery(session, connection, table.getRelationHandle(), Optional.empty(), columns, (Map<String, String>)ImmutableMap.of(), table.getConstraint(), split.getAdditionalPredicate()));
        return queryBuilder.prepareStatement(session, connection, preparedQuery);
    }

    protected PreparedQuery applyQueryTransformations(JdbcTableHandle tableHandle, PreparedQuery query) {
        PreparedQuery preparedQuery = query;
        if (tableHandle.getLimit().isPresent()) {
            preparedQuery = tableHandle.getSortOrder().isPresent() ? preparedQuery.transformQuery(this.applyTopN(tableHandle.getSortOrder().get(), tableHandle.getLimit().getAsLong())) : preparedQuery.transformQuery(this.applyLimit(tableHandle.getLimit().getAsLong()));
        }
        return preparedQuery;
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            return this.createTable(session, tableMetadata, this.generateTemporaryTableName());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected JdbcOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, String tableName) throws SQLException {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        JdbcIdentity identity = JdbcIdentity.from(session);
        if (!this.getSchemaNames(session).contains(schemaTableName.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema not found: " + schemaTableName.getSchemaName());
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
            String remoteSchema = this.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
            String remoteTable = this.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
            if (uppercase) {
                tableName = tableName.toUpperCase(Locale.ENGLISH);
            }
            String catalog = connection.getCatalog();
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder columnList = ImmutableList.builder();
            for (ColumnMetadata column : tableMetadata.getColumns()) {
                String columnName = column.getName();
                if (uppercase) {
                    columnName = columnName.toUpperCase(Locale.ENGLISH);
                }
                columnNames.add((Object)columnName);
                columnTypes.add((Object)column.getType());
                columnList.add((Object)this.getColumnDefinitionSql(session, column, columnName));
            }
            RemoteTableName remoteTableName = new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), tableName);
            String sql = this.createTableSql(remoteTableName, (List<String>)columnList.build(), tableMetadata);
            this.execute(connection, sql);
            JdbcOutputTableHandle jdbcOutputTableHandle = new JdbcOutputTableHandle(catalog, remoteSchema, remoteTable, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.empty(), tableName);
            return jdbcOutputTableHandle;
        }
    }

    protected String createTableSql(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        return String.format("CREATE TABLE %s (%s)", this.quoted(remoteTableName), String.join((CharSequence)", ", columns));
    }

    protected String getColumnDefinitionSql(ConnectorSession session, ColumnMetadata column, String columnName) {
        StringBuilder sb = new StringBuilder().append(this.quoted(columnName)).append(" ").append(this.toWriteMapping(session, column.getType()).getDataType());
        if (!column.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        JdbcOutputTableHandle jdbcOutputTableHandle;
        block10: {
            SchemaTableName schemaTableName = tableHandle.asPlainTable().getSchemaTableName();
            JdbcIdentity identity = JdbcIdentity.from(session);
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
                String remoteSchema = this.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
                String remoteTable = this.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
                String tableName = this.generateTemporaryTableName();
                if (uppercase) {
                    tableName = tableName.toUpperCase(Locale.ENGLISH);
                }
                String catalog = connection.getCatalog();
                ImmutableList.Builder columnNames = ImmutableList.builder();
                ImmutableList.Builder columnTypes = ImmutableList.builder();
                ImmutableList.Builder jdbcColumnTypes = ImmutableList.builder();
                for (JdbcColumnHandle column : columns) {
                    columnNames.add((Object)column.getColumnName());
                    columnTypes.add((Object)column.getColumnType());
                    jdbcColumnTypes.add((Object)column.getJdbcTypeHandle());
                }
                this.copyTableSchema(connection, catalog, remoteSchema, remoteTable, tableName, (List<String>)columnNames.build());
                jdbcOutputTableHandle = new JdbcOutputTableHandle(catalog, remoteSchema, remoteTable, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(jdbcColumnTypes.build()), tableName);
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return jdbcOutputTableHandle;
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("CREATE TABLE %s AS SELECT %s FROM %s WHERE 0 = 1", this.quoted(catalogName, schemaName, newTableName), columnNames.stream().map(this::quoted).collect(Collectors.joining(", ")), this.quoted(catalogName, schemaName, tableName));
        this.execute(connection, sql);
    }

    protected String generateTemporaryTableName() {
        return "tmp_trino_" + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.renameTable(session, handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName(), new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.renameTable(session, handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), newTableName);
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String newSchemaName = newTable.getSchemaName();
            String newTableName = newTable.getTableName();
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                newSchemaName = newSchemaName.toUpperCase(Locale.ENGLISH);
                newTableName = newTableName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(catalogName, newSchemaName, newTableName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        Connection connection;
        String temporaryTable = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName());
        String targetTable = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName());
        String columnNames = handle.getColumnNames().stream().map(this::quoted).collect(Collectors.joining(", "));
        String insertSql = String.format("INSERT INTO %s (%s) SELECT %s FROM %s", targetTable, columnNames, columnNames, temporaryTable);
        String cleanupSql = "DROP TABLE " + temporaryTable;
        try {
            connection = this.getConnection(session, handle);
            try {
                this.execute(connection, insertSql);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            connection = this.getConnection(session, handle);
            try {
                this.execute(connection, cleanupSql);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            log.warn((Throwable)e, "Failed to cleanup temporary table: %s", new Object[]{temporaryTable});
        }
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String columnName = column.getName();
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                columnName = columnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s ADD %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.getColumnDefinitionSql(session, column, columnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                newColumnName = newColumnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(handle.asPlainTable().getRemoteTableName()), jdbcColumn.getColumnName(), newColumnName);
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        String sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.quoted(handle.asPlainTable().getRemoteTableName()), column.getColumnName());
        this.execute(session, sql);
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle handle) {
        String sql = "DROP TABLE " + this.quoted(handle.asPlainTable().getRemoteTableName());
        this.execute(session, sql);
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.dropTable(session, new JdbcTableHandle(new SchemaTableName(handle.getSchemaName(), handle.getTemporaryTableName()), handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()));
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        Preconditions.checkArgument((handle.getColumnNames().size() == columnWriters.size() ? 1 : 0) != 0, (String)"handle and columnWriters mismatch: %s, %s", (Object)handle, columnWriters);
        return String.format("INSERT INTO %s (%s) VALUES (%s)", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()), handle.getColumnNames().stream().map(this::quoted).collect(Collectors.joining(", ")), columnWriters.stream().map(WriteFunction::getBindExpression).collect(Collectors.joining(",")));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.connectionFactory.openConnection(session);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return connection.prepareStatement(sql);
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(connection.getCatalog(), BaseJdbcClient.escapeNamePattern(schemaName, metadata.getSearchStringEscape()).orElse(null), BaseJdbcClient.escapeNamePattern(tableName, metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    protected Optional<List<String>> getTableTypes() {
        return Optional.of(ImmutableList.of((Object)"TABLE", (Object)"VIEW"));
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_SCHEM");
    }

    protected String toRemoteSchemaName(JdbcIdentity identity, Connection connection, String schemaName) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)schemaName), (String)"Expected schema name from internal metadata to be lowercase: %s", (Object)schemaName);
        if (this.caseInsensitiveNameMatching) {
            try {
                String remoteSchema;
                Map<String, String> mapping = (Map<String, String>)this.remoteSchemaNames.getIfPresent((Object)identity);
                if (mapping != null && !mapping.containsKey(schemaName)) {
                    mapping = null;
                }
                if (mapping == null) {
                    mapping = this.listSchemasByLowerCase(connection);
                    this.remoteSchemaNames.put((Object)identity, mapping);
                }
                if ((remoteSchema = (String)mapping.get(schemaName)) != null) {
                    return remoteSchema;
                }
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to find remote schema name: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
            }
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                return schemaName.toUpperCase(Locale.ENGLISH);
            }
            return schemaName;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected Map<String, String> listSchemasByLowerCase(Connection connection) {
        return (Map)this.listSchemas(connection).stream().collect(ImmutableMap.toImmutableMap(schemaName -> schemaName.toLowerCase(Locale.ENGLISH), schemaName -> schemaName));
    }

    protected String toRemoteTableName(JdbcIdentity identity, Connection connection, String remoteSchema, String tableName) {
        Objects.requireNonNull(remoteSchema, "remoteSchema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)tableName), (String)"Expected table name from internal metadata to be lowercase: %s", (Object)tableName);
        if (this.caseInsensitiveNameMatching) {
            try {
                String remoteTable;
                RemoteTableNameCacheKey cacheKey = new RemoteTableNameCacheKey(identity, remoteSchema);
                Map<String, String> mapping = (Map<String, String>)this.remoteTableNames.getIfPresent((Object)cacheKey);
                if (mapping != null && !mapping.containsKey(tableName)) {
                    mapping = null;
                }
                if (mapping == null) {
                    mapping = this.listTablesByLowerCase(connection, remoteSchema);
                    this.remoteTableNames.put((Object)cacheKey, mapping);
                }
                if ((remoteTable = (String)mapping.get(tableName)) != null) {
                    return remoteTable;
                }
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to find remote table name: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
            }
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                return tableName.toUpperCase(Locale.ENGLISH);
            }
            return tableName;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected Map<String, String> listTablesByLowerCase(Connection connection, String remoteSchema) {
        ImmutableMap immutableMap;
        block9: {
            ResultSet resultSet = this.getTables(connection, Optional.of(remoteSchema), Optional.empty());
            try {
                ImmutableMap.Builder map = ImmutableMap.builder();
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    map.put((Object)tableName.toLowerCase(Locale.ENGLISH), (Object)tableName);
                }
                immutableMap = map.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableMap;
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return TableStatistics.empty();
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        this.execute(session, "CREATE SCHEMA " + this.quoted(schemaName));
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName) {
        this.execute(session, "DROP SCHEMA " + this.quoted(schemaName));
    }

    protected void execute(ConnectorSession session, String query) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            this.execute(connection, query);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void execute(Connection connection, String query) {
        try (Statement statement = connection.createStatement();){
            log.debug("Execute: %s", new Object[]{query});
            statement.execute(query);
        }
        catch (SQLException e) {
            TrinoException exception = new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
            exception.addSuppressed((Throwable)new RuntimeException("Query: " + query));
            throw exception;
        }
    }

    @Deprecated
    protected WriteMapping legacyToWriteMapping(ConnectorSession session, Type type) {
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping("char(" + ((CharType)type).getLength() + ")", StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping(dataType, StandardColumnMappings.shortDecimalWriteFunction(decimalType));
            }
            return WriteMapping.sliceMapping(dataType, StandardColumnMappings.longDecimalWriteFunction(decimalType));
        }
        WriteMapping writeMapping = WRITE_MAPPINGS.get(type);
        if (writeMapping != null) {
            return writeMapping;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<SortItem> sortOrder) {
        return this.topNFunction().isPresent();
    }

    protected Optional<TopNFunction> topNFunction() {
        return Optional.empty();
    }

    private Function<String, String> applyTopN(List<SortItem> sortOrder, long limit) {
        return query -> this.topNFunction().orElseThrow().apply((String)query, sortOrder, limit);
    }

    @Override
    public boolean isTopNLimitGuaranteed(ConnectorSession session) {
        throw new UnsupportedOperationException("topNFunction() implemented without implementing isTopNLimitGuaranteed()");
    }

    @Override
    public boolean supportsLimit() {
        return this.limitFunction().isPresent();
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.empty();
    }

    private Function<String, String> applyLimit(long limit) {
        return query -> this.limitFunction().orElseThrow().apply((String)query, limit);
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "limitFunction() is implemented without isLimitGuaranteed()");
    }

    @Override
    public String quoted(String name) {
        name = name.replace(this.identifierQuote, this.identifierQuote + this.identifierQuote);
        return this.identifierQuote + name + this.identifierQuote;
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.quoted(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName());
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        return Collections.emptyMap();
    }

    protected String quoted(@Nullable String catalog, @Nullable String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sb.append(this.quoted(catalog)).append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    protected static Optional<String> escapeNamePattern(Optional<String> name, String escape) {
        return name.map(string -> BaseJdbcClient.escapeNamePattern(string, escape));
    }

    private static String escapeNamePattern(String name, String escape) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(escape, "escape is null");
        Preconditions.checkArgument((!escape.isEmpty() ? 1 : 0) != 0, (Object)"Escape string must not be empty");
        Preconditions.checkArgument((!escape.equals("_") ? 1 : 0) != 0, (Object)"Escape string must not be '_'");
        Preconditions.checkArgument((!escape.equals("%") ? 1 : 0) != 0, (Object)"Escape string must not be '%'");
        name = name.replace(escape, escape + escape);
        name = name.replace("_", escape + "_");
        name = name.replace("%", escape + "%");
        return name;
    }

    private static RemoteTableName getRemoteTable(ResultSet resultSet) throws SQLException {
        return new RemoteTableName(Optional.ofNullable(resultSet.getString("TABLE_CAT")), Optional.ofNullable(resultSet.getString("TABLE_SCHEM")), resultSet.getString("TABLE_NAME"));
    }

    @FunctionalInterface
    public static interface TopNFunction {
        public String apply(String var1, List<SortItem> var2, long var3);
    }
}

