/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class BaseJdbcConfig {
    private String connectionUrl;
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);
    private Set<String> jdbcTypesMappedToVarchar = ImmutableSet.of();
    private Duration metadataCacheTtl = new Duration(0.0, TimeUnit.MINUTES);
    private boolean cacheMissing;

    @NotNull
    @Pattern(regexp="^jdbc:[a-z0-9]+:(?s:.*)$", flags={Pattern.Flag.CASE_INSENSITIVE})
    public @NotNull @Pattern(regexp="^jdbc:[a-z0-9]+:(?s:.*)$", flags={Pattern.Flag.CASE_INSENSITIVE}) String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="connection-url")
    public BaseJdbcConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="case-insensitive-name-matching")
    public BaseJdbcConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="case-insensitive-name-matching.cache-ttl")
    public BaseJdbcConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    public Set<String> getJdbcTypesMappedToVarchar() {
        return this.jdbcTypesMappedToVarchar;
    }

    @Config(value="jdbc-types-mapped-to-varchar")
    public BaseJdbcConfig setJdbcTypesMappedToVarchar(String jdbcTypesMappedToVarchar) {
        this.jdbcTypesMappedToVarchar = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)Strings.nullToEmpty((String)jdbcTypesMappedToVarchar)));
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="metadata.cache-ttl")
    @ConfigDescription(value="Determines how long meta information will be cached")
    public BaseJdbcConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    public boolean isCacheMissing() {
        return this.cacheMissing;
    }

    @Config(value="metadata.cache-missing")
    @ConfigDescription(value="Determines if missing information will be cached")
    public BaseJdbcConfig setCacheMissing(boolean cacheMissing) {
        this.cacheMissing = cacheMissing;
        return this;
    }
}

