/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface JdbcClient {
    default public boolean schemaExists(ConnectorSession session, String schema) {
        return this.getSchemaNames(session).contains(schema);
    }

    public Set<String> getSchemaNames(ConnectorSession var1);

    public List<SchemaTableName> getTableNames(ConnectorSession var1, Optional<String> var2);

    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession var1, SchemaTableName var2);

    public List<JdbcColumnHandle> getColumns(ConnectorSession var1, JdbcTableHandle var2);

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession var1, Connection var2, JdbcTypeHandle var3);

    public List<ColumnMapping> toColumnMappings(ConnectorSession var1, List<JdbcTypeHandle> var2);

    public WriteMapping toWriteMapping(ConnectorSession var1, Type var2);

    default public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<List<ColumnHandle>> groupingSets) {
        return true;
    }

    default public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return Optional.empty();
    }

    public ConnectorSplitSource getSplits(ConnectorSession var1, JdbcTableHandle var2);

    public Connection getConnection(ConnectorSession var1, JdbcSplit var2) throws SQLException;

    default public void abortReadConnection(Connection connection) throws SQLException {
    }

    public PreparedQuery prepareQuery(ConnectorSession var1, JdbcTableHandle var2, Optional<List<List<JdbcColumnHandle>>> var3, List<JdbcColumnHandle> var4, Map<String, String> var5);

    public PreparedStatement buildSql(ConnectorSession var1, Connection var2, JdbcSplit var3, JdbcTableHandle var4, List<JdbcColumnHandle> var5) throws SQLException;

    public Optional<PreparedQuery> implementJoin(ConnectorSession var1, JoinType var2, PreparedQuery var3, PreparedQuery var4, List<JdbcJoinCondition> var5, Map<JdbcColumnHandle, String> var6, Map<JdbcColumnHandle, String> var7, JoinStatistics var8);

    public boolean supportsTopN(ConnectorSession var1, JdbcTableHandle var2, List<SortItem> var3);

    public boolean isTopNLimitGuaranteed(ConnectorSession var1);

    public boolean supportsLimit();

    public boolean isLimitGuaranteed(ConnectorSession var1);

    default public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column comments");
    }

    public void addColumn(ConnectorSession var1, JdbcTableHandle var2, ColumnMetadata var3);

    public void dropColumn(ConnectorSession var1, JdbcTableHandle var2, JdbcColumnHandle var3);

    public void renameColumn(ConnectorSession var1, JdbcTableHandle var2, JdbcColumnHandle var3, String var4);

    public void renameTable(ConnectorSession var1, JdbcTableHandle var2, SchemaTableName var3);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(ConnectorSession var1, JdbcOutputTableHandle var2);

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession var1, JdbcTableHandle var2, List<JdbcColumnHandle> var3);

    public void finishInsertTable(ConnectorSession var1, JdbcOutputTableHandle var2);

    public void dropTable(ConnectorSession var1, JdbcTableHandle var2);

    public void rollbackCreateTable(ConnectorSession var1, JdbcOutputTableHandle var2);

    public String buildInsertSql(JdbcOutputTableHandle var1, List<WriteFunction> var2);

    public Connection getConnection(ConnectorSession var1, JdbcOutputTableHandle var2) throws SQLException;

    public PreparedStatement getPreparedStatement(Connection var1, String var2) throws SQLException;

    public TableStatistics getTableStatistics(ConnectorSession var1, JdbcTableHandle var2, TupleDomain<ColumnHandle> var3);

    public void createSchema(ConnectorSession var1, String var2);

    public void dropSchema(ConnectorSession var1, String var2);

    default public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return Optional.empty();
    }

    public String quoted(String var1);

    public String quoted(RemoteTableName var1);

    public Map<String, Object> getTableProperties(ConnectorSession var1, JdbcTableHandle var2);

    default public Optional<TableScanRedirectApplicationResult> getTableScanRedirection(ConnectorSession session, JdbcTableHandle tableHandle) {
        return Optional.empty();
    }
}

