/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcRelationHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class JdbcTableHandle
implements ConnectorTableHandle {
    private final JdbcRelationHandle relationHandle;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<List<SortItem>> sortOrder;
    private final OptionalLong limit;
    private final Optional<List<JdbcColumnHandle>> columns;
    private final int nextSyntheticColumnId;

    @Deprecated
    public JdbcTableHandle(SchemaTableName schemaTableName, @Nullable String catalogName, @Nullable String schemaName, String tableName) {
        this(schemaTableName, new RemoteTableName(Optional.ofNullable(catalogName), Optional.ofNullable(schemaName), tableName));
    }

    public JdbcTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName) {
        this(new JdbcNamedRelationHandle(schemaTableName, remoteTableName), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), OptionalLong.empty(), Optional.empty(), 0);
    }

    @JsonCreator
    public JdbcTableHandle(@JsonProperty(value="relationHandle") JdbcRelationHandle relationHandle, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="sortOrder") Optional<List<SortItem>> sortOrder, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="columns") Optional<List<JdbcColumnHandle>> columns, @JsonProperty(value="nextSyntheticColumnId") int nextSyntheticColumnId) {
        this.relationHandle = Objects.requireNonNull(relationHandle, "relationHandle is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null").map(ImmutableList::copyOf);
        this.limit = Objects.requireNonNull(limit, "limit is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columns = columns.map(ImmutableList::copyOf);
        this.nextSyntheticColumnId = nextSyntheticColumnId;
    }

    @Deprecated
    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return this.getRequiredNamedRelation().getSchemaTableName();
    }

    @Deprecated
    @JsonIgnore
    public RemoteTableName getRemoteTableName() {
        return this.getRequiredNamedRelation().getRemoteTableName();
    }

    public JdbcNamedRelationHandle asPlainTable() {
        Preconditions.checkState((!this.isSynthetic() ? 1 : 0) != 0, (String)"The table handle does not represent a plain table: %s", (Object)this);
        return this.getRequiredNamedRelation();
    }

    @JsonIgnore
    public JdbcNamedRelationHandle getRequiredNamedRelation() {
        Preconditions.checkState((boolean)this.isNamedRelation(), (String)"The table handle does not represent a named relation: %s", (Object)this);
        return (JdbcNamedRelationHandle)this.relationHandle;
    }

    @JsonProperty
    public JdbcRelationHandle getRelationHandle() {
        return this.relationHandle;
    }

    @Deprecated
    @JsonIgnore
    @Nullable
    public String getCatalogName() {
        return this.getRemoteTableName().getCatalogName().orElse(null);
    }

    @Deprecated
    @JsonIgnore
    @Nullable
    public String getSchemaName() {
        return this.getRemoteTableName().getSchemaName().orElse(null);
    }

    @Deprecated
    @JsonIgnore
    public String getTableName() {
        return this.getRemoteTableName().getTableName();
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public Optional<List<JdbcColumnHandle>> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<List<SortItem>> getSortOrder() {
        return this.sortOrder;
    }

    @JsonProperty
    public int getNextSyntheticColumnId() {
        return this.nextSyntheticColumnId;
    }

    @JsonIgnore
    public boolean isSynthetic() {
        return !this.isNamedRelation() || !this.constraint.isAll() || this.sortOrder.isPresent() || this.limit.isPresent();
    }

    @JsonIgnore
    public boolean isNamedRelation() {
        return this.relationHandle instanceof JdbcNamedRelationHandle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcTableHandle o = (JdbcTableHandle)obj;
        return Objects.equals(this.relationHandle, o.relationHandle) && Objects.equals(this.constraint, o.constraint) && Objects.equals(this.sortOrder, o.sortOrder) && Objects.equals(this.limit, o.limit) && Objects.equals(this.columns, o.columns) && this.nextSyntheticColumnId == o.nextSyntheticColumnId;
    }

    public int hashCode() {
        return Objects.hash(this.relationHandle, this.constraint, this.sortOrder, this.limit, this.columns, this.nextSyntheticColumnId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.relationHandle);
        if (this.constraint.isNone()) {
            builder.append(" constraint=FALSE");
        } else if (!this.constraint.isAll()) {
            builder.append(" constraint on ");
            builder.append(((Map)this.constraint.getDomains().orElseThrow()).keySet().stream().map(columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName()).collect(Collectors.joining(", ", "[", "]")));
        }
        this.sortOrder.ifPresent(value -> builder.append(" sortOrder=").append(value));
        this.limit.ifPresent(value -> builder.append(" limit=").append(value));
        this.columns.ifPresent(value -> builder.append(" columns=").append(value));
        return builder.toString();
    }
}

