/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.expression.AggregateFunctionPatterns;
import io.trino.plugin.jdbc.expression.AggregateFunctionRule;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DoubleType;
import java.util.Optional;

public class ImplementStddevPop
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();

    @Override
    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"stddev_pop")).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().matching(DoubleType.class::isInstance)).capturedAs(INPUT)));
    }

    @Override
    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(input.getName());
        Verify.verify((aggregateFunction.getOutputType() == columnHandle.getColumnType() ? 1 : 0) != 0);
        return Optional.of(new JdbcExpression(String.format("stddev_pop(%s)", context.getIdentifierQuote().apply(columnHandle.getColumnName())), columnHandle.getJdbcTypeHandle()));
    }
}

