/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mysql;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.AggregateFunctionPatterns;
import io.trino.plugin.jdbc.expression.AggregateFunctionRule;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import java.util.Optional;

public class ImplementAvgBigint
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"avg")).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().matching(type -> type == BigintType.BIGINT)).capturedAs(INPUT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(input.getName());
        Verify.verify((aggregateFunction.getOutputType() == DoubleType.DOUBLE ? 1 : 0) != 0);
        return Optional.of(new JdbcExpression(String.format("avg((%s * 1.0))", context.getIdentifierQuote().apply(columnHandle.getColumnName())), new JdbcTypeHandle(8, Optional.of("double"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())));
    }
}

