/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mysql;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.mysql.jdbc.Statement;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.AggregateFunctionRewriter;
import io.trino.plugin.jdbc.expression.ImplementAvgDecimal;
import io.trino.plugin.jdbc.expression.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.expression.ImplementCount;
import io.trino.plugin.jdbc.expression.ImplementCountAll;
import io.trino.plugin.jdbc.expression.ImplementMinMax;
import io.trino.plugin.jdbc.expression.ImplementStddevPop;
import io.trino.plugin.jdbc.expression.ImplementStddevSamp;
import io.trino.plugin.jdbc.expression.ImplementSum;
import io.trino.plugin.jdbc.expression.ImplementVariancePop;
import io.trino.plugin.jdbc.expression.ImplementVarianceSamp;
import io.trino.plugin.mysql.ImplementAvgBigint;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.inject.Inject;

public class MySqlClient
extends BaseJdbcClient {
    private final Type jsonType;
    private final AggregateFunctionRewriter aggregateFunctionRewriter;

    @Inject
    public MySqlClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, TypeManager typeManager) {
        super(config, "`", connectionFactory);
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(arg_0 -> ((MySqlClient)this).quoted(arg_0), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax()).add((Object)new ImplementSum(MySqlClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).build());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getCatalogs();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_CAT");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        if (schemaName.equalsIgnoreCase("mysql")) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    public void abortReadConnection(Connection connection) throws SQLException {
        connection.abort(MoreExecutors.directExecutor());
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        if (statement.isWrapperFor(Statement.class)) {
            statement.unwrap(Statement.class).enableStreamingResults();
        }
        return statement;
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(schemaName.orElse(null), null, MySqlClient.escapeNamePattern(tableName, (String)metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        Optional<ColumnMapping> unsignedMapping = MySqlClient.getUnsignedMapping(typeHandle);
        if (unsignedMapping.isPresent()) {
            return unsignedMapping;
        }
        if (jdbcTypeName.equalsIgnoreCase("json")) {
            return Optional.of(this.jsonColumnMapping());
        }
        switch (typeHandle.getJdbcType()) {
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 3: {
                int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
                int precision = typeHandle.getRequiredColumnSize();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if ((precision += Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (SliceReadFunction)StandardColumnMappings.varbinaryReadFunction(), (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMapping());
            }
        }
        return this.legacyToPrestoType(session, connection, typeHandle);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunction());
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            return WriteMapping.longMapping((String)"datetime", (LongWriteFunction)StandardColumnMappings.timestampWriteFunctionUsingSqlTimestamp((TimestampType)TimestampType.TIMESTAMP_MILLIS));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"mediumblob", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping((String)("char(" + ((CharType)type).getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            String dataType = varcharType.isUnbounded() ? "longtext" : (varcharType.getBoundedLength() <= 255 ? "tinytext" : (varcharType.getBoundedLength() <= 65535 ? "text" : (varcharType.getBoundedLength() <= 0xFFFFFF ? "mediumtext" : "longtext")));
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type.equals(this.jsonType)) {
            return WriteMapping.sliceMapping((String)"json", (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        return this.legacyToWriteMapping(session, type);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = "42S01".equals(e.getSQLState());
            throw new TrinoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                newColumnName = newColumnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), this.quoted(jdbcColumn.getColumnName()), this.quoted(newColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            if ("42000".equals(e.getSQLState())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Rename column not supported in catalog: '%s'", handle.getCatalogName()), (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String tableCopyFormat = "CREATE TABLE %s AS SELECT * FROM %s WHERE 0 = 1";
        if (MySqlClient.isGtidMode(connection)) {
            tableCopyFormat = "CREATE TABLE %s LIKE %s";
        }
        String sql = String.format(tableCopyFormat, this.quoted(catalogName, schemaName, newTableName), this.quoted(catalogName, schemaName, tableName));
        this.execute(connection, sql);
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        Verify.verify((handle.getSchemaName() == null ? 1 : 0) != 0);
        this.renameTable(session, null, handle.getCatalogName(), handle.getTableName(), newTableName);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.implementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    protected boolean isSupportedJoinCondition(JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IS_DISTINCT_FROM) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isGtidMode(Connection connection) {
        try (java.sql.Statement statement = connection.createStatement();){
            boolean bl;
            block18: {
                ResultSet resultSet;
                block16: {
                    boolean bl2;
                    block17: {
                        resultSet = statement.executeQuery("SHOW VARIABLES LIKE 'gtid_mode'");
                        try {
                            if (!resultSet.next()) break block16;
                            boolean bl3 = bl2 = !resultSet.getString("Value").equalsIgnoreCase("OFF");
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return bl2;
                }
                bl = false;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static Optional<ColumnMapping> getUnsignedMapping(JdbcTypeHandle typeHandle) {
        if (typeHandle.getJdbcTypeName().isEmpty()) {
            return Optional.empty();
        }
        String typeName = (String)typeHandle.getJdbcTypeName().get();
        if (typeName.equalsIgnoreCase("tinyint unsigned")) {
            return Optional.of(StandardColumnMappings.smallintColumnMapping());
        }
        if (typeName.equalsIgnoreCase("smallint unsigned")) {
            return Optional.of(StandardColumnMappings.integerColumnMapping());
        }
        if (typeName.equalsIgnoreCase("int unsigned")) {
            return Optional.of(StandardColumnMappings.bigintColumnMapping());
        }
        if (typeName.equalsIgnoreCase("bigint unsigned")) {
            return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)20)));
        }
        return Optional.empty();
    }
}

