/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mysql;

import com.mysql.jdbc.Driver;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import java.sql.SQLException;
import java.util.Properties;
import javax.validation.constraints.AssertTrue;

public class MySqlJdbcConfig
extends BaseJdbcConfig {
    @AssertTrue(message="Invalid JDBC URL for MySQL connector")
    public @AssertTrue(message="Invalid JDBC URL for MySQL connector") boolean isUrlValid() {
        try {
            Driver driver = new Driver();
            Properties properties = driver.parseURL(this.getConnectionUrl(), null);
            return properties != null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @AssertTrue(message="Database (catalog) must not be specified in JDBC URL for MySQL connector")
    public @AssertTrue(message="Database (catalog) must not be specified in JDBC URL for MySQL connector") boolean isUrlWithoutDatabase() {
        try {
            Driver driver = new Driver();
            Properties properties = driver.parseURL(this.getConnectionUrl(), null);
            return properties == null || driver.database(properties) == null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

