/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.plugin.opa.ForOpa;
import io.trino.plugin.opa.OpaAccessControlModule;
import io.trino.plugin.opa.OpaHighLevelClient;
import io.trino.plugin.opa.OpaHttpClient;
import io.trino.plugin.opa.schema.OpaBatchColumnMaskQueryResult;
import io.trino.plugin.opa.schema.OpaColumnMaskQueryResult;
import io.trino.plugin.opa.schema.OpaPluginContext;
import io.trino.plugin.opa.schema.OpaQuery;
import io.trino.plugin.opa.schema.OpaQueryResult;
import io.trino.plugin.opa.schema.OpaRowFiltersQueryResult;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class OpaAccessControlFactory
implements SystemAccessControlFactory {
    public String getName() {
        return "opa";
    }

    public SystemAccessControl create(Map<String, String> config, SystemAccessControlFactory.SystemAccessControlContext context) {
        return OpaAccessControlFactory.create(config, Optional.empty(), Optional.ofNullable(context));
    }

    @VisibleForTesting
    protected static SystemAccessControl create(Map<String, String> config, Optional<HttpClient> httpClient, Optional<SystemAccessControlFactory.SystemAccessControlContext> context) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(context, "context is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), binder -> {
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OpaQuery.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OpaQueryResult.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OpaRowFiltersQueryResult.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OpaColumnMaskQueryResult.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OpaBatchColumnMaskQueryResult.class);
            httpClient.ifPresentOrElse(client -> binder.bind(Key.get(HttpClient.class, ForOpa.class)).toInstance(client), () -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("opa", ForOpa.class));
            context.ifPresentOrElse(actualContext -> {
                binder.bind(OpaPluginContext.class).toInstance((Object)new OpaPluginContext(actualContext.getVersion()));
                binder.bind(OpenTelemetry.class).toInstance((Object)actualContext.getOpenTelemetry());
                binder.bind(Tracer.class).toInstance((Object)actualContext.getTracer());
            }, () -> binder.bind(OpaPluginContext.class).toInstance((Object)new OpaPluginContext("UNKNOWN")));
            binder.bind(OpaHighLevelClient.class);
            binder.bind(Key.get(Executor.class, ForOpa.class)).toProvider(ExecutorProvider.class).in(Scopes.SINGLETON);
            binder.bind(OpaHttpClient.class).in(Scopes.SINGLETON);
        }, new OpaAccessControlModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (SystemAccessControl)injector.getInstance(SystemAccessControl.class);
    }

    private static class ExecutorProvider
    implements Provider<Executor> {
        private final Executor executor = new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"opa-access-control-http-%s")), Runtime.getRuntime().availableProcessors());

        private ExecutorProvider() {
        }

        public Executor get() {
            return this.executor;
        }
    }
}

