/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Optional;

public class OpaConfig {
    private URI opaUri;
    private Optional<URI> opaBatchUri = Optional.empty();
    private boolean logRequests;
    private boolean logResponses;
    private boolean allowPermissionManagementOperations;
    private Optional<URI> opaRowFiltersUri = Optional.empty();
    private Optional<URI> opaColumnMaskingUri = Optional.empty();
    private Optional<URI> opaBatchColumnMaskingUri = Optional.empty();

    @NotNull
    public URI getOpaUri() {
        return this.opaUri;
    }

    @Config(value="opa.policy.uri")
    @ConfigDescription(value="URI for OPA policies")
    public OpaConfig setOpaUri(@NotNull URI opaUri) {
        this.opaUri = opaUri;
        return this;
    }

    @NotNull
    public Optional<URI> getOpaBatchUri() {
        return this.opaBatchUri;
    }

    @Config(value="opa.policy.batched-uri")
    @ConfigDescription(value="URI for Batch OPA policies - if not set, a single request will be sent for each entry on filtering methods")
    public OpaConfig setOpaBatchUri(URI opaBatchUri) {
        this.opaBatchUri = Optional.ofNullable(opaBatchUri);
        return this;
    }

    public boolean getLogRequests() {
        return this.logRequests;
    }

    @Config(value="opa.log-requests")
    @ConfigDescription(value="Whether to log requests (URI, entire body and headers) prior to sending them to OPA")
    public OpaConfig setLogRequests(boolean logRequests) {
        this.logRequests = logRequests;
        return this;
    }

    public boolean getLogResponses() {
        return this.logResponses;
    }

    @Config(value="opa.log-responses")
    @ConfigDescription(value="Whether to log responses (URI, entire body, status code and headers) received from OPA")
    public OpaConfig setLogResponses(boolean logResponses) {
        this.logResponses = logResponses;
        return this;
    }

    public boolean getAllowPermissionManagementOperations() {
        return this.allowPermissionManagementOperations;
    }

    @Config(value="opa.allow-permission-management-operations")
    @ConfigDescription(value="Whether to allow permission management (GRANT, DENY, ...) and role management operations - OPA will not be queried for any such operations, they will be bulk allowed or denied depending on this setting")
    public OpaConfig setAllowPermissionManagementOperations(boolean allowPermissionManagementOperations) {
        this.allowPermissionManagementOperations = allowPermissionManagementOperations;
        return this;
    }

    @NotNull
    public Optional<URI> getOpaRowFiltersUri() {
        return this.opaRowFiltersUri;
    }

    @Config(value="opa.policy.row-filters-uri")
    @ConfigDescription(value="URI for fetching row filters - if not set no row filtering will be applied")
    public OpaConfig setOpaRowFiltersUri(@NotNull URI opaRowFiltersUri) {
        this.opaRowFiltersUri = Optional.ofNullable(opaRowFiltersUri);
        return this;
    }

    @NotNull
    public Optional<URI> getOpaColumnMaskingUri() {
        return this.opaColumnMaskingUri;
    }

    @Config(value="opa.policy.column-masking-uri")
    @ConfigDescription(value="URI for fetching column masks - if not set no masking will be applied")
    public OpaConfig setOpaColumnMaskingUri(URI opaColumnMaskingUri) {
        this.opaColumnMaskingUri = Optional.ofNullable(opaColumnMaskingUri);
        return this;
    }

    @NotNull
    public Optional<URI> getOpaBatchColumnMaskingUri() {
        return this.opaBatchColumnMaskingUri;
    }

    @Config(value="opa.policy.batch-column-masking-uri")
    @ConfigDescription(value="URI for fetching batch column masks - if not set column-masking-uri will be used")
    public OpaConfig setOpaBatchColumnMaskingUri(URI opaBatchColumnMaskingUri) {
        this.opaBatchColumnMaskingUri = Optional.ofNullable(opaBatchColumnMaskingUri);
        return this;
    }
}

