/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.JsonBodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.plugin.opa.ForOpa;
import io.trino.plugin.opa.OpaConfig;
import io.trino.plugin.opa.OpaQueryException;
import io.trino.plugin.opa.schema.OpaBatchQueryResult;
import io.trino.plugin.opa.schema.OpaColumnMaskQueryResult;
import io.trino.plugin.opa.schema.OpaQuery;
import io.trino.plugin.opa.schema.OpaQueryInput;
import io.trino.plugin.opa.schema.OpaQueryResult;
import io.trino.plugin.opa.schema.OpaViewExpression;
import io.trino.spi.connector.ColumnSchema;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;

public class OpaHttpClient {
    private final HttpClient httpClient;
    private final JsonCodec<OpaQuery> serializer;
    private final Executor executor;
    private final boolean logRequests;
    private final boolean logResponses;
    private static final Logger log = Logger.get(OpaHttpClient.class);

    @Inject
    public OpaHttpClient(@ForOpa HttpClient httpClient, JsonCodec<OpaQuery> serializer, @ForOpa Executor executor, OpaConfig config) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.serializer = Objects.requireNonNull(serializer, "serializer is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.logRequests = config.getLogRequests();
        this.logResponses = config.getLogResponses();
    }

    public <T> FluentFuture<T> submitOpaRequest(OpaQueryInput input, URI uri, JsonCodec<T> deserializer) {
        Request request;
        JsonBodyGenerator requestBodyGenerator;
        try {
            requestBodyGenerator = JsonBodyGenerator.jsonBodyGenerator(this.serializer, (Object)new OpaQuery(input));
            request = Request.Builder.preparePost().addHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setUri(uri).setBodyGenerator((BodyGenerator)requestBodyGenerator).build();
        }
        catch (IllegalArgumentException e) {
            log.error((Throwable)e, "Failed to serialize OPA request body when attempting to send request to URI \"%s\"", new Object[]{uri.toString()});
            throw new OpaQueryException.SerializeFailed(e);
        }
        if (this.logRequests) {
            log.debug("Sending OPA request to URI \"%s\" ; request body = %s ; request headers = %s", new Object[]{uri.toString(), new String(requestBodyGenerator.getBody(), StandardCharsets.UTF_8), request.getHeaders()});
        }
        return FluentFuture.from((ListenableFuture)this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(deserializer))).transform(response -> this.parseOpaResponse((FullJsonResponseHandler.JsonResponse)response, uri), this.executor);
    }

    public <T> T consumeOpaResponse(ListenableFuture<T> opaResponseFuture) {
        try {
            return (T)opaResponseFuture.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof OpaQueryException) {
                OpaQueryException queryException = (OpaQueryException)throwable;
                throw queryException;
            }
            log.error((Throwable)e, "Failed to obtain response from OPA due to an unknown error");
            throw new OpaQueryException.QueryFailed(e);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e, "OPA request was interrupted in flight");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public Map<ColumnSchema, OpaViewExpression> parallelColumnMasksFromOpa(List<ColumnSchema> items, Function<ColumnSchema, OpaQueryInput> requestBuilder, URI uri, JsonCodec<? extends OpaColumnMaskQueryResult> deserializer) {
        return (Map)this.parallelRequest(items, requestBuilder, (item, result) -> result.result().map(viewExpression -> Map.entry(item, viewExpression)), uri, deserializer).stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public <T> Set<T> parallelFilterFromOpa(Collection<T> items, Function<T, OpaQueryInput> requestBuilder, URI uri, JsonCodec<? extends OpaQueryResult> deserializer) {
        return ImmutableSet.copyOf(this.parallelRequest(items, requestBuilder, (item, result) -> result.result() ? Optional.of(item) : Optional.empty(), uri, deserializer));
    }

    public <T> Set<T> batchFilterFromOpa(Collection<T> items, Function<List<T>, OpaQueryInput> requestBuilder, URI uri, JsonCodec<? extends OpaBatchQueryResult> deserializer) {
        if (items.isEmpty()) {
            return ImmutableSet.of();
        }
        String dummyMapKey = "filter";
        return (Set)this.parallelBatchFilterFromOpa((Map)ImmutableMap.of((Object)dummyMapKey, items), (BiFunction)(mapKey, mapValue) -> (OpaQueryInput)requestBuilder.apply((List)mapValue), uri, deserializer).getOrDefault(dummyMapKey, (Set<ImmutableSet>)ImmutableSet.of());
    }

    public <K, V> Map<K, Set<V>> parallelBatchFilterFromOpa(Map<K, ? extends Collection<V>> items, BiFunction<K, List<V>, OpaQueryInput> requestBuilder, URI uri, JsonCodec<? extends OpaBatchQueryResult> deserializer) {
        List parallelRequestItems = (List)items.entrySet().stream().filter(entry -> !((Collection)entry.getValue()).isEmpty()).map(entry -> Map.entry(entry.getKey(), ImmutableList.copyOf((Collection)((Collection)entry.getValue())))).collect(ImmutableList.toImmutableList());
        return (Map)this.parallelRequest(parallelRequestItems, entry -> (OpaQueryInput)requestBuilder.apply(entry.getKey(), (List)entry.getValue()), (entry, result) -> Optional.of((List)Objects.requireNonNullElse(result.result(), ImmutableList.of())).flatMap(indices -> indices.isEmpty() ? Optional.empty() : Optional.of(indices)).map(indices -> (ImmutableSet)indices.stream().map(index -> ((ImmutableList)entry.getValue()).get(index.intValue())).collect(ImmutableSet.toImmutableSet())).map(values -> Map.entry(entry.getKey(), values)), uri, deserializer).stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private <T> T parseOpaResponse(FullJsonResponseHandler.JsonResponse<T> response, URI uri) {
        int statusCode = response.getStatusCode();
        String uriString = uri.toString();
        if (HttpStatus.familyForStatusCode((int)statusCode) != HttpStatus.Family.SUCCESSFUL) {
            if (statusCode == HttpStatus.NOT_FOUND.code()) {
                log.warn("OPA responded with not found error for policy with URI \"%s\"", new Object[]{uriString});
                throw new OpaQueryException.PolicyNotFound(uriString);
            }
            log.error("Received unknown error from OPA for URI \"%s\" with status code = %d", new Object[]{uriString, statusCode});
            throw new OpaQueryException.OpaServerError(uriString, statusCode, response.toString());
        }
        if (!response.hasValue()) {
            log.error((Throwable)response.getException(), "OPA response for URI \"%s\" with status code = %d could not be deserialized", new Object[]{uriString, statusCode});
            throw new OpaQueryException.DeserializeFailed(response.getException());
        }
        if (this.logResponses) {
            log.debug("OPA response for URI \"%s\" received: status code = %d ; response payload = %s ; response headers = %s", new Object[]{uriString, statusCode, new String(response.getJsonBytes(), StandardCharsets.UTF_8), response.getHeaders()});
        }
        return (T)response.getValue();
    }

    private <T, U, X> List<X> parallelRequest(Collection<T> items, Function<T, OpaQueryInput> requestBuilder, BiFunction<T, U, Optional<X>> parser, URI uri, JsonCodec<U> deserializer) {
        if (items.isEmpty()) {
            return ImmutableList.of();
        }
        List allFutures = (List)items.stream().map(item -> this.submitOpaRequest((OpaQueryInput)requestBuilder.apply(item), uri, deserializer).transform(result -> (Optional)parser.apply(item, result), this.executor)).collect(ImmutableList.toImmutableList());
        return (List)this.consumeOpaResponse(Futures.whenAllComplete((Iterable)allFutures).call(() -> (ImmutableList)allFutures.stream().map(this::consumeOpaResponse).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()), this.executor));
    }
}

