/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

public abstract class OpaQueryException
extends RuntimeException {
    public OpaQueryException(String message, Throwable cause) {
        super(message, cause);
    }

    public static final class OpaServerError
    extends OpaQueryException {
        public OpaServerError(String policyName, int statusCode, String extra) {
            super("OPA server returned status %d when processing policy %s: %s".formatted(statusCode, policyName, extra), null);
        }
    }

    public static final class PolicyNotFound
    extends OpaQueryException {
        public PolicyNotFound(String policyName) {
            super("OPA policy named %s did not return a value (or does not exist)".formatted(policyName), null);
        }
    }

    public static final class DeserializeFailed
    extends OpaQueryException {
        public DeserializeFailed(Throwable cause) {
            super("Failed to deserialize OPA policy response", cause);
        }
    }

    public static final class SerializeFailed
    extends OpaQueryException {
        public SerializeFailed(Throwable cause) {
            super("Failed to serialize OPA query context", cause);
        }
    }

    public static final class QueryFailed
    extends OpaQueryException {
        public QueryFailed(Throwable cause) {
            super("Failed to query OPA backend", cause);
        }
    }
}

