/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.opa.schema.OpaQueryInputResource;
import io.trino.plugin.opa.schema.TrinoGrantPrincipal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record OpaQueryInputAction(String operation, OpaQueryInputResource resource, List<OpaQueryInputResource> filterResources, OpaQueryInputResource targetResource, TrinoGrantPrincipal grantee) {
    public OpaQueryInputAction {
        Objects.requireNonNull(operation, "operation is null");
        if (filterResources != null && resource != null) {
            throw new IllegalArgumentException("resource and filterResources cannot both be configured");
        }
        if (filterResources != null) {
            filterResources = ImmutableList.copyOf(filterResources);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String operation;
        private OpaQueryInputResource resource;
        private List<OpaQueryInputResource> filterResources;
        private OpaQueryInputResource targetResource;
        private TrinoGrantPrincipal grantee;

        private Builder() {
        }

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder resource(OpaQueryInputResource resource) {
            this.resource = resource;
            return this;
        }

        public Builder filterResources(Collection<OpaQueryInputResource> resources) {
            this.filterResources = ImmutableList.copyOf(resources);
            return this;
        }

        public Builder targetResource(OpaQueryInputResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public Builder grantee(TrinoGrantPrincipal grantee) {
            this.grantee = grantee;
            return this;
        }

        public OpaQueryInputAction build() {
            return new OpaQueryInputAction(this.operation, this.resource, this.filterResources, this.targetResource, this.grantee);
        }
    }
}

