/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.trino.plugin.opa.schema.TrinoCatalogSessionProperty;
import io.trino.plugin.opa.schema.TrinoColumn;
import io.trino.plugin.opa.schema.TrinoFunction;
import io.trino.plugin.opa.schema.TrinoSchema;
import io.trino.plugin.opa.schema.TrinoTable;
import io.trino.plugin.opa.schema.TrinoUser;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record OpaQueryInputResource(TrinoUser user, NamedEntity systemSessionProperty, TrinoCatalogSessionProperty catalogSessionProperty, TrinoFunction function, NamedEntity catalog, TrinoSchema schema, TrinoTable table, TrinoColumn column) {
    public static Builder builder() {
        return new Builder();
    }

    public record NamedEntity(String name) {
        public NamedEntity {
            Objects.requireNonNull(name, "name is null");
        }
    }

    public static class Builder {
        private TrinoUser user;
        private NamedEntity systemSessionProperty;
        private TrinoCatalogSessionProperty catalogSessionProperty;
        private NamedEntity catalog;
        private TrinoSchema schema;
        private TrinoTable table;
        private TrinoFunction function;
        private TrinoColumn column;

        private Builder() {
        }

        public Builder user(TrinoUser user) {
            this.user = user;
            return this;
        }

        public Builder systemSessionProperty(String systemSessionProperty) {
            this.systemSessionProperty = new NamedEntity(systemSessionProperty);
            return this;
        }

        public Builder catalogSessionProperty(TrinoCatalogSessionProperty catalogSessionProperty) {
            this.catalogSessionProperty = catalogSessionProperty;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = new NamedEntity(catalog);
            return this;
        }

        public Builder schema(TrinoSchema schema) {
            this.schema = schema;
            return this;
        }

        public Builder table(TrinoTable table) {
            this.table = table;
            return this;
        }

        public Builder function(TrinoFunction function) {
            this.function = function;
            return this;
        }

        public Builder function(String functionName) {
            this.function = new TrinoFunction(functionName);
            return this;
        }

        public Builder column(TrinoColumn column) {
            this.column = column;
            return this;
        }

        public OpaQueryInputResource build() {
            return new OpaQueryInputResource(this.user, this.systemSessionProperty, this.catalogSessionProperty, this.function, this.catalog, this.schema, this.table, this.column);
        }
    }
}

