/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.openlineage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClient;
import io.trino.plugin.openlineage.OpenLineageTrinoFacet;
import io.trino.plugin.openlineage.config.OpenLineageListenerConfig;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.QueryFailureInfo;
import io.trino.spi.eventlistener.QueryIOMetadata;
import io.trino.spi.eventlistener.QueryMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.eventlistener.TableInfo;
import io.trino.spi.resourcegroups.QueryType;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class OpenLineageListener
implements EventListener {
    private static final Logger logger = Logger.get(OpenLineageListener.class);
    private static final ObjectMapper QUERY_STATISTICS_MAPPER = new ObjectMapperProvider().get();
    private final OpenLineage openLineage = new OpenLineage(URI.create("https://github.com/trinodb/trino/plugin/trino-openlineage"));
    private final OpenLineageClient client;
    private final String jobNamespace;
    private final String datasetNamespace;
    private final Set<QueryType> includeQueryTypes;

    @Inject
    public OpenLineageListener(OpenLineageClient client, OpenLineageListenerConfig listenerConfig) {
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(listenerConfig, "listenerConfig is null");
        this.jobNamespace = listenerConfig.getNamespace().orElse(OpenLineageListener.defaultNamespace(listenerConfig.getTrinoURI()));
        this.datasetNamespace = OpenLineageListener.defaultNamespace(listenerConfig.getTrinoURI());
        this.includeQueryTypes = ImmutableSet.copyOf(listenerConfig.getIncludeQueryTypes());
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        if (this.queryTypeSupported(queryCreatedEvent.getContext())) {
            UUID runID = this.getQueryId(queryCreatedEvent.getMetadata());
            OpenLineage.RunEvent event = this.getStartEvent(runID, queryCreatedEvent);
            this.client.emit(event);
            return;
        }
        logger.debug("Query type %s not supported. Supported query types %s", new Object[]{queryCreatedEvent.getContext().getQueryType().toString(), this.includeQueryTypes});
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        if (this.queryTypeSupported(queryCompletedEvent.getContext())) {
            UUID runID = this.getQueryId(queryCompletedEvent.getMetadata());
            OpenLineage.RunEvent event = this.getCompletedEvent(runID, queryCompletedEvent);
            this.client.emit(event);
            return;
        }
        logger.debug("Query type %s not supported. Supported query types %s", new Object[]{queryCompletedEvent.getContext().getQueryType().toString(), this.includeQueryTypes});
    }

    private boolean queryTypeSupported(QueryContext queryContext) {
        return queryContext.getQueryType().map(this.includeQueryTypes::contains).orElse(false);
    }

    private UUID getQueryId(QueryMetadata queryMetadata) {
        return UUID.nameUUIDFromBytes(queryMetadata.getQueryId().getBytes(StandardCharsets.UTF_8));
    }

    private OpenLineage.RunFacet getTrinoQueryContextFacet(QueryContext queryContext) {
        OpenLineage.RunFacet queryContextFacet = this.openLineage.newRunFacet();
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"server_address", (Object)queryContext.getServerAddress());
        properties.put((Object)"environment", (Object)queryContext.getEnvironment());
        queryContext.getQueryType().ifPresent(queryType -> properties.put((Object)"query_type", (Object)queryType.toString()));
        queryContextFacet.getAdditionalProperties().putAll(properties.buildOrThrow());
        return queryContextFacet;
    }

    private OpenLineage.RunFacet getTrinoMetadataFacet(QueryMetadata queryMetadata) {
        OpenLineage.RunFacet trinoMetadataFacet = this.openLineage.newRunFacet();
        ImmutableMap.Builder properties = ImmutableMap.builder();
        queryMetadata.getPlan().ifPresent(queryPlan -> properties.put((Object)"query_plan", queryPlan));
        queryMetadata.getTransactionId().ifPresent(transactionId -> properties.put((Object)"transaction_id", transactionId));
        trinoMetadataFacet.getAdditionalProperties().putAll(properties.buildOrThrow());
        return trinoMetadataFacet;
    }

    private OpenLineage.RunFacet getTrinoQueryStatisticsFacet(QueryStatistics queryStatistics) {
        OpenLineage.RunFacet trinoQueryStatisticsFacet = this.openLineage.newRunFacet();
        ImmutableMap.Builder properties = ImmutableMap.builder();
        ((HashMap)QUERY_STATISTICS_MAPPER.convertValue((Object)queryStatistics, HashMap.class)).forEach((key, value) -> {
            if (key != null && value != null) {
                properties.put((Object)key.toString(), (Object)value.toString());
            }
        });
        trinoQueryStatisticsFacet.getAdditionalProperties().putAll(properties.buildOrThrow());
        return trinoQueryStatisticsFacet;
    }

    public OpenLineage.RunEvent getStartEvent(UUID runID, QueryCreatedEvent queryCreatedEvent) {
        OpenLineage.RunFacetsBuilder runFacetsBuilder = this.getBaseRunFacetsBuilder(queryCreatedEvent.getContext());
        runFacetsBuilder.put(OpenLineageTrinoFacet.TRINO_METADATA.asText(), this.getTrinoMetadataFacet(queryCreatedEvent.getMetadata()));
        runFacetsBuilder.put(OpenLineageTrinoFacet.TRINO_QUERY_CONTEXT.asText(), this.getTrinoQueryContextFacet(queryCreatedEvent.getContext()));
        return this.openLineage.newRunEventBuilder().eventType(OpenLineage.RunEvent.EventType.START).eventTime(queryCreatedEvent.getCreateTime().atZone(ZoneOffset.UTC)).run(this.openLineage.newRunBuilder().runId(runID).facets(runFacetsBuilder.build()).build()).job(this.getBaseJobBuilder(queryCreatedEvent.getMetadata()).build()).build();
    }

    public OpenLineage.RunEvent getCompletedEvent(UUID runID, QueryCompletedEvent queryCompletedEvent) {
        boolean failed = queryCompletedEvent.getMetadata().getQueryState().equals("FAILED");
        OpenLineage.RunFacetsBuilder runFacetsBuilder = this.getBaseRunFacetsBuilder(queryCompletedEvent.getContext());
        runFacetsBuilder.put(OpenLineageTrinoFacet.TRINO_METADATA.asText(), this.getTrinoMetadataFacet(queryCompletedEvent.getMetadata()));
        runFacetsBuilder.put(OpenLineageTrinoFacet.TRINO_QUERY_CONTEXT.asText(), this.getTrinoQueryContextFacet(queryCompletedEvent.getContext()));
        runFacetsBuilder.put(OpenLineageTrinoFacet.TRINO_QUERY_STATISTICS.asText(), this.getTrinoQueryStatisticsFacet(queryCompletedEvent.getStatistics()));
        if (failed) {
            queryCompletedEvent.getFailureInfo().flatMap(QueryFailureInfo::getFailureMessage).ifPresent(failureMessage -> runFacetsBuilder.errorMessage(this.openLineage.newErrorMessageRunFacetBuilder().message(failureMessage).build()));
        }
        return this.openLineage.newRunEventBuilder().eventType(failed ? OpenLineage.RunEvent.EventType.FAIL : OpenLineage.RunEvent.EventType.COMPLETE).eventTime(queryCompletedEvent.getEndTime().atZone(ZoneOffset.UTC)).run(this.openLineage.newRunBuilder().runId(runID).facets(runFacetsBuilder.build()).build()).job(this.getBaseJobBuilder(queryCompletedEvent.getMetadata()).build()).inputs(this.buildInputs(queryCompletedEvent.getMetadata())).outputs(this.buildOutputs(queryCompletedEvent.getIoMetadata())).build();
    }

    private OpenLineage.RunFacetsBuilder getBaseRunFacetsBuilder(QueryContext queryContext) {
        return this.openLineage.newRunFacetsBuilder().processing_engine(this.openLineage.newProcessingEngineRunFacetBuilder().name("trino").version(queryContext.getServerVersion()).build());
    }

    private OpenLineage.JobBuilder getBaseJobBuilder(QueryMetadata queryMetadata) {
        return this.openLineage.newJobBuilder().namespace(this.jobNamespace).name(queryMetadata.getQueryId()).facets(this.openLineage.newJobFacetsBuilder().jobType(this.openLineage.newJobTypeJobFacet("BATCH", "TRINO", "QUERY")).sql(this.openLineage.newSQLJobFacet(queryMetadata.getQuery())).build());
    }

    private List<OpenLineage.InputDataset> buildInputs(QueryMetadata queryMetadata) {
        return (List)queryMetadata.getTables().stream().filter(TableInfo::isDirectlyReferenced).map(table -> {
            String datasetName = this.getDatasetName((TableInfo)table);
            OpenLineage.InputDatasetBuilder inputDatasetBuilder = this.openLineage.newInputDatasetBuilder().namespace(this.datasetNamespace).name(datasetName);
            OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.openLineage.newDatasetFacetsBuilder().schema(this.openLineage.newSchemaDatasetFacetBuilder().fields(table.getColumns().stream().map(field -> this.openLineage.newSchemaDatasetFacetFieldsBuilder().name(field.getColumn()).build()).toList()).build());
            return inputDatasetBuilder.facets(datasetFacetsBuilder.build()).build();
        }).collect(ImmutableList.toImmutableList());
    }

    private List<OpenLineage.OutputDataset> buildOutputs(QueryIOMetadata ioMetadata) {
        Optional outputs = ioMetadata.getOutput();
        if (outputs.isPresent()) {
            QueryOutputMetadata outputMetadata = (QueryOutputMetadata)outputs.get();
            List outputColumns = outputMetadata.getColumns().orElse(List.of());
            OpenLineage.ColumnLineageDatasetFacetFieldsBuilder columnLineageDatasetFacetFieldsBuilder = this.openLineage.newColumnLineageDatasetFacetFieldsBuilder();
            outputColumns.forEach(column -> columnLineageDatasetFacetFieldsBuilder.put(column.getColumnName(), this.openLineage.newColumnLineageDatasetFacetFieldsAdditionalBuilder().inputFields(column.getSourceColumns().stream().map(inputColumn -> this.openLineage.newColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder().field(inputColumn.getColumnName()).namespace(this.datasetNamespace).name(this.getDatasetName(inputColumn.getCatalog(), inputColumn.getSchema(), inputColumn.getTable())).build()).toList()).build()));
            return ImmutableList.of((Object)this.openLineage.newOutputDatasetBuilder().namespace(this.datasetNamespace).name(this.getDatasetName(outputMetadata.getCatalogName(), outputMetadata.getSchema(), outputMetadata.getTable())).facets(this.openLineage.newDatasetFacetsBuilder().columnLineage(this.openLineage.newColumnLineageDatasetFacet(columnLineageDatasetFacetFieldsBuilder.build())).schema(this.openLineage.newSchemaDatasetFacetBuilder().fields(outputColumns.stream().map(column -> this.openLineage.newSchemaDatasetFacetFieldsBuilder().name(column.getColumnName()).type(column.getColumnType()).build()).toList()).build()).build()).build());
        }
        return ImmutableList.of();
    }

    private String getDatasetName(TableInfo tableInfo) {
        return this.getDatasetName(tableInfo.getCatalog(), tableInfo.getSchema(), tableInfo.getTable());
    }

    private String getDatasetName(String catalogName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", catalogName, schemaName, tableName);
    }

    private static String defaultNamespace(URI uri) {
        if (!uri.getScheme().isEmpty()) {
            return uri.toString().replace(uri.getScheme(), "trino");
        }
        return "trino://" + String.valueOf(uri);
    }
}

