/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.openlineage;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.openlineage.client.OpenLineageClient;
import io.trino.plugin.openlineage.OpenLineageListener;
import io.trino.plugin.openlineage.OpenLineageTransport;
import io.trino.plugin.openlineage.OpenLineageTrinoFacet;
import io.trino.plugin.openlineage.config.OpenLineageListenerConfig;
import io.trino.plugin.openlineage.config.http.OpenLineageClientHttpTransportConfig;
import io.trino.plugin.openlineage.transport.OpenLineageConsoleTransport;
import io.trino.plugin.openlineage.transport.http.OpenLineageHttpTransport;

public class OpenLineageListenerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(OpenLineageListener.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OpenLineageListenerConfig.class);
        this.install(ConditionalModule.conditionalModule(OpenLineageListenerConfig.class, config -> config.getTransport().equals((Object)OpenLineageTransport.CONSOLE), internalBinder -> internalBinder.bind(io.trino.plugin.openlineage.transport.OpenLineageTransport.class).to(OpenLineageConsoleTransport.class)));
        this.install(ConditionalModule.conditionalModule(OpenLineageListenerConfig.class, config -> config.getTransport().equals((Object)OpenLineageTransport.HTTP), internalBinder -> {
            ConfigBinder.configBinder((Binder)internalBinder).bindConfig(OpenLineageClientHttpTransportConfig.class);
            internalBinder.bind(io.trino.plugin.openlineage.transport.OpenLineageTransport.class).to(OpenLineageHttpTransport.class);
        }));
    }

    @Provides
    @Singleton
    private OpenLineageClient getClient(OpenLineageListenerConfig listenerConfig, io.trino.plugin.openlineage.transport.OpenLineageTransport openLineageTransport) throws Exception {
        OpenLineageClient.Builder clientBuilder = OpenLineageClient.builder();
        clientBuilder.transport(openLineageTransport.buildTransport());
        String[] disabledFacets = (String[])listenerConfig.getDisabledFacets().stream().map(OpenLineageTrinoFacet::asText).toArray(String[]::new);
        clientBuilder.disableFacets(disabledFacets);
        return clientBuilder.build();
    }
}

